function [cont, all_cont] = extract_2_cont(im, n_contsamp)
	%- Extract contour, count only the longest contours
    [Cs]	= boundary_extract_binary(im);
%     n_max	= 0;
%     i_max	= 0;
%     for cc=1:length(Cs)
%         if size(Cs{cc},2)>n_max
%             n_max = size(Cs{cc},2);
%             i_max = cc;
%         end
%     end
    
    lens = [];
    for i = 1:length(Cs)
        lens(i) = size( Cs{i}, 2 );
    end
    [lens, IND] = sort( lens, 'descend' );
    
    n1 = round( n_contsamp * lens(1) / (lens(1)+lens(2)) );
    n2 = n_contsamp - n1;
    
    [cont1, all_cont1] = cont_pro( im, Cs{IND(1)}', n1 );
    [cont2, all_cont2] = cont_pro( im, Cs{IND(2)}', n2 );
    
    cont = [cont1; cont2];
    all_cont = [ all_cont1; all_cont2 ];
            
 function [cont, all_cont] = cont_pro(im, cont, n_contsamp)
    % remove redundant point in contours
    cont		= [cont; cont(1,:)];
    dif_cont	= abs(diff(cont,1,1));
    id_gd		= find(sum(dif_cont,2)>0.001);
    cont		= cont(id_gd,:);
            
    % force the contour to be anti-clockwisecomputed above is at the different orientation
    bClock		= is_clockwise(cont,im);
    if bClock	cont	= flipud(cont);		end
            
    % start from bottom
    [min_v,id]	= min(cont(:,2));
    cont		= circshift(cont,[length(cont)-id+1]);
    
    all_cont = cont;
            
	[XIs,YIs]	= uniform_interp(cont(:,1),cont(:,2),n_contsamp-1);
	cont		= [cont(1,:); [XIs YIs]];
