clc;clear;close all;

%% path setting
addpath(genpath('data'));
addpath(genpath('measure'));

%% run the experiment for each data sets
dataPath = 'data';
dataSets = dir(fullfile(dataPath,'*.mat'));

%% parameter
numIterKmeans = 20;
numIterAff =  10;
K = 10;
for i = 1 : length(dataSets)
   % load data, data is the similarity matrices for each view
   dataName = dataSets(i).name; 
   load(fullfile(dataPath,dataName));
   numClust = length(unique(trueLabel));
   
   % baseline
   fprintf('----------Data sets: %s--------------\n', dataName);
   for view = 1 : length(data)
       fprintf('Run baseline algorithm for view % d: \n',view);
       baseline_spectral(data{view},numClust,trueLabel,numIterKmeans);
   end
   
   % our method
   fprintf('Run our algorithm with tensor product graph addtion: \n');
   affinity_learning(data,trueLabel,numClust,numIterKmeans,numIterAff,K);
end



