function baseline_spectral(W,numClust,trueLabel,numIterKmeans)
% Input: 
% X: N x N simiarity matrix.
% numClust: desired number of clusters
% trueLabel: N x 1 vector of ground trueLabel clusterings

W = (W+W')/2;
W = W - diag(diag(W));
[V,D] = compute_L(W,numClust);
U = V(:,1:numClust);
normMat = repmat(sqrt(sum(U.*U,2)),1,size(U,2));
for k=1:size(normMat,1)
    if (normMat(k,1)==0)
        normMat(k,:) = 1;
    end
end
U = U./normMat;
[Fi,Pi,Ri,nmii,avgenti,ARi] = iterative_run_kmeans(U,trueLabel,numIterKmeans);

fprintf('F: %f(%f)\n', mean(Fi), std(Fi));
fprintf('P: %f(%f)\n', mean(Pi), std(Pi));    
fprintf('R: %f(%f)\n', mean(Ri), std(Ri));
fprintf('nmi: %f(%f)\n',mean(nmii), std(nmii));
fprintf('avgent: %f(%f)\n',mean(avgenti), std(avgenti));
fprintf('AR: %f(%f)\n', mean(ARi), std(ARi));
fprintf('\n');