% Function ghostDist
% Longin Jan Latecki 2009
% Modified by Suzan Koknar-Tezel June 2009
%
% This function takes three points (a, b, x) and assumes a ghost point (e)
% that lies halfway between a and b. It then calculates the distance from
% this ghost point e to the point x.
%
% For a complete discription, see the article "Improving SVM classification 
%    on imbalanced time series data sets with ghost points". Knowledge and 
%    Information Systems: Volume 28, Issue 1 (2011), Page 1-23

function ex=ghostDist(rhoab,rhoax,rhoxb)

%input: rhoab,rhoax,rhoxb corresponds to terms in formula (1)
%output: ex=rho(x, mu(a,b))
%
%case 1
%if triange inequality holds for x, a, b
if (rhoax + rhoxb >= rhoab) && (rhoab + rhoxb >= rhoax)  && (rhoab + rhoax >= rhoxb)
    ex = sqrt( 0.5*rhoax^2 + 0.5*rhoxb^2 - 0.25*rhoab^2 );
    return;
end

%we are here if triangle inequality does not hold for x, a, b
ab=rhoab;
if rhoax >= rhoxb
    ax=rhoax;
    xb=rhoxb;
else
    xb=rhoax;
    ax=rhoxb;
end
%This way always ax >= xb
 
%case 2
if ax + xb < ab
    ex= (ab/2) - xb;
end

%case 3
if ab + xb < ax
    ex= (abs((ab/2) - xb) + abs((ab/2) - ax))/2;
end


return
