#include <ctime>
#include "DSP.h"

void main(int argc, void* argv[])
{
	if(argc!=3)
		return;

	DSP dsp;
	dsp.ReadProblem((char*)argv[1]);

	clock_t begin = clock();
	dsp.Solve();
	clock_t end = clock();
	double elapsed_secs = double(end - begin) / CLOCKS_PER_SEC;

	std::cout << "NumOfVar: "<< dsp.m_NumVar << " NumOfTerm: "<< dsp.m_NumOfTerms << " UsedTime: " << elapsed_secs <<std::endl;	

	dsp.OuputPartition((char*)argv[2]);
	dsp.Release();	
	
}