#include <math.h>
#include <limits>
#include "QPBO\QPBO.h"
#include "DSP.h"
#pragma warning(disable:4018)

int compareID(const void * a, const void * b)
{
	IntDouble* pa = (IntDouble*)a;
	IntDouble* pb = (IntDouble*)b;

	double dif = pa->D - pb->D;

	if(dif<0)
		return -1;
	else if(dif>0)
		return 1;	
	else
		return 0;
}

void DSP::GetPartition(int* pEndPos, int* pMark)
{	
	int count = 0;	
	SubPermutation* ptr = m_pHead;
	while(ptr!=NULL)
	{
		pEndPos[count] = ptr->EndPos;
		pMark[count]   = ptr->Singature;
		count++;
		ptr = ptr->pNext;
	}
}

void DSP::ReadProblem(char* FileName)
{
	FILE* fp;
    fopen_s(&fp,FileName,"rb");
	int ibuff[1024];
	double dbuff[1024];
	fread(ibuff,sizeof(int),4,fp);
	int NumOfVar = ibuff[0];
	int NumOfTerms = ibuff[1];
	int IsInit = ibuff[2];
	int IsRoundNumber = ibuff[3];
	

	SetNumOfVar(NumOfVar);
	SetMaxNumOfTerms(NumOfTerms);

	for(int i=0;i<NumOfTerms;i++)
	{
		fread(ibuff,sizeof(int),1,fp);
		int numVer = ibuff[0];
		fread(ibuff,sizeof(int),numVer,fp);
		fread(dbuff,sizeof(double),1,fp);
		AddTerm(ibuff,numVer,dbuff[0]);
	}	

	if(IsInit==1)
	{
		int* pibuff = new int[NumOfVar];
		fread(pibuff,sizeof(int),NumOfVar,fp);
		SetInitPermutation(pibuff);
		delete[] pibuff;
	}
	
	if(IsRoundNumber==1)
	{
		fread(ibuff,sizeof(int),1,fp);
		SetRoundInteger(ibuff[0]);
	}

	fclose(fp);
}

void DSP::OuputPartition(char* FileName)
{
	FILE* fp;
	fopen_s(&fp,FileName,"wb");
	m_pIntBuf1[0] = m_NumVar;
	int NumOfPartition = GetNumOfPartition();
	m_pIntBuf1[1] = NumOfPartition;
	fwrite(m_pIntBuf1,sizeof(int),2,fp);
	fwrite(m_pXOrder,sizeof(int),m_NumVar,fp);
	fwrite(m_pRewards,sizeof(double),m_NumVar,fp);
	GetPartition(m_pIntBuf1,m_pIntBuf2);
	fwrite(m_pIntBuf1,sizeof(int),NumOfPartition,fp);
	fwrite(m_pIntBuf2,sizeof(int),NumOfPartition,fp);
	fclose(fp);
}

void DSP::Init(void)
{	
	if(!IsInitalized)
	{
		for(int i=0;i<m_NumVar;i++)
		{
			m_pXOrder[i] = i;
			m_pInvXOrder[i] = i;
		}

		GreedyOptimalOrder(0,m_NumVar-1,m_pIntBuf1,m_pDoubleBuf1);
		for(int i=0;i<m_NumVar;i++)
		{
			int temp = m_pIntBuf1[i];
			m_pXOrder[i] = temp;
			m_pInvXOrder[temp] = i;
			m_pRewards[i] = m_pDoubleBuf1[i];
		}

		BuildVertex2Term();	
	}
	else	
	{
		BuildVertex2Term();	
		UpdateReward(0,m_NumVar-1);
	}	
}

void DSP::Release(void)
{
	delete[] m_pXOrder;
	delete[] m_pInvXOrder;
	delete[] m_pRewards;
	delete[] m_pIntBuf1;
	delete[] m_pIntBuf2;
	delete[] m_pDoubleBuf1;
	delete[] m_pDoubleBuf2;	
	delete[] m_pIDBuf;
	SubPermutation* ptr = m_pHead;

	while(ptr!=NULL)
	{
		SubPermutation* ptemp = ptr;
		ptr = ptr->pNext;
		delete ptemp;
	}	

	for(int i=0;i<m_NumOfTerms;i++)
		delete[] m_pTerms[i].Vars;
	delete[] m_pTerms;

	for(int i=0;i<m_NumVar;i++)
		delete[] m_pVertex2Term[i].pBuf;
	delete[] m_pVertex2Term;
}

void DSP::BuildVertex2Term(void)
{
	m_pVertex2Term = new FLenBuf[m_NumVar];
	for(int i=0;i<m_NumVar;i++)
	{
		m_pVertex2Term[i].Len = 0;
		m_pVertex2Term[i].Dim = 0;
	}

	for(int i=0;i<m_NumOfTerms;i++)
	{
		for(int j=0;j<m_pTerms[i].NumElem;j++)
		{
			int VIdx = m_pTerms[i].Vars[j];
			m_pVertex2Term[VIdx].Dim++;
		}
	}

	for(int i=0;i<m_NumVar;i++)
		m_pVertex2Term[i].pBuf = new int[m_pVertex2Term[i].Dim];

	for(int i=0;i<m_NumOfTerms;i++)
	{
		int MaxIdx = -1;
		for(int j=0;j<m_pTerms[i].NumElem;j++)
		{
			int VIdx = m_pTerms[i].Vars[j];
			int VPos = m_pInvXOrder[VIdx];
			MaxIdx = MaxIdx>VPos? MaxIdx:VPos;			
		}

		MaxIdx = m_pXOrder[MaxIdx];
		int num = m_pVertex2Term[MaxIdx].Len;
		m_pVertex2Term[MaxIdx].pBuf[num] = i;
		m_pVertex2Term[MaxIdx].Len ++;
	}
}

// time complexity: O(m+nlog(n))
double DSP::GreedyOptimalOrder(int StartPos, int EndPos, int* pNewOrder, double* pNewReward)
{
	int NumOfVar = EndPos - StartPos + 1;		
	for(int i=0;i<NumOfVar;i++)
	{
		m_pIDBuf[i].I = i;
		m_pIDBuf[i].D = 0;
	}

	if(NumOfVar<m_NumVar)
	{
		for(int i=StartPos;i<=EndPos;i++)
		{
			int VIdx = m_pXOrder[i];
			for(int j=0;j<m_pVertex2Term[VIdx].Len;j++)
			{ 
				int TIdx = m_pVertex2Term[VIdx].pBuf[j];
				Term& term = m_pTerms[TIdx];

				int ptr = 0;
				for(int k=0;k<term.NumElem;k++)
				{
					int curIdx = m_pInvXOrder[term.Vars[k]];
					curIdx -= StartPos;
					if(curIdx<0)
						continue;
					m_pIntBuf2[ptr++] = curIdx;				
				}

				double val = term.c/ptr;
				for(int k=0;k<ptr;k++)
					m_pIDBuf[m_pIntBuf2[k]].D += val;
			}
		}
		qsort(m_pIDBuf,NumOfVar,sizeof(IntDouble),compareID);

		for(int i=0;i<NumOfVar;i++)	
			pNewOrder[i] = m_pIDBuf[NumOfVar-1-i].I;		
	
		for(int i=0;i<NumOfVar;i++)
		{
			pNewReward[i] = 0;
			m_pIntBuf2[pNewOrder[i]] = i;		
			pNewOrder[i] = m_pXOrder[pNewOrder[i]+StartPos];
		}
	
		for(int i=StartPos;i<=EndPos;i++)
		{
			int VIdx = m_pXOrder[i];
			for(int j=0;j<m_pVertex2Term[VIdx].Len;j++)
			{ 
				int TIdx = m_pVertex2Term[VIdx].pBuf[j];
				Term& term = m_pTerms[TIdx];
				int MaxIdx = -1;
				for(int k=0;k<term.NumElem;k++)
				{
					int curIdx = m_pInvXOrder[term.Vars[k]];
					curIdx -= StartPos;
					if(curIdx<0)
						continue;
					curIdx = m_pIntBuf2[curIdx];
					MaxIdx = MaxIdx>curIdx?MaxIdx:curIdx;
				}

				pNewReward[MaxIdx] += term.c;
			}
		}	
	}
	else
	{
		for(int i=0;i<m_NumOfTerms;i++)
		{
			Term& term = m_pTerms[i];
			int ptr = 0;
			for(int k=0;k<term.NumElem;k++)
			{
				int curIdx = m_pInvXOrder[term.Vars[k]];				
				m_pIntBuf2[ptr++] = curIdx;				
			}

			double val = term.c/ptr;
			for(int k=0;k<ptr;k++)
				m_pIDBuf[m_pIntBuf2[k]].D += val;
		}
		qsort(m_pIDBuf,NumOfVar,sizeof(IntDouble),compareID);

		for(int i=0;i<NumOfVar;i++)	
			pNewOrder[i] = m_pIDBuf[NumOfVar-1-i].I;		
	
		for(int i=0;i<NumOfVar;i++)
		{
			pNewReward[i] = 0;
			m_pIntBuf2[pNewOrder[i]] = i;		
			pNewOrder[i] = m_pXOrder[pNewOrder[i]+StartPos];
		}

		for(int i=0;i<m_NumOfTerms;i++)
		{
			Term& term = m_pTerms[i];
			int MaxIdx = -1;
			for(int k=0;k<term.NumElem;k++)
			{
				int curIdx = m_pInvXOrder[term.Vars[k]];				
				curIdx = m_pIntBuf2[curIdx];
				MaxIdx = MaxIdx>curIdx?MaxIdx:curIdx;
			}

			pNewReward[MaxIdx] += term.c;
		}	
	}

	double MaxVal = pNewReward[0];
	double sum = MaxVal;
	int count = 1;
	for(int i=1;i<NumOfVar;i++)
	{
		count++;
		sum += pNewReward[i];
		double aSum = sum/count;
		if(aSum>MaxVal)
			MaxVal = aSum;
	}

	return MaxVal;
}

void DSP::UpdateOrder(int StartPos, int EndPos, int* pNewOrder)
{	
	// change order
	for(int i=StartPos;i<=EndPos;i++)
	{
		int NewIdx = pNewOrder[i-StartPos];
		m_pXOrder[i] = NewIdx;
		m_pInvXOrder[NewIdx] = i;
	}

	UpdateVertexTermRelation(StartPos,EndPos);

	// update rewards
	UpdateReward(StartPos,EndPos);	
}

// time complexity: O(n+m)
void DSP::UpdateReward(int StartPos, int EndPos)
{
	for(int i=StartPos;i<=EndPos;i++)
	{
		m_pRewards[i] = 0;
		int VIdx = m_pXOrder[i];
		for(int j=0;j<m_pVertex2Term[VIdx].Len;j++)
		{
			int TIdx = m_pVertex2Term[VIdx].pBuf[j];
			m_pRewards[i] += m_pTerms[TIdx].c;
		}
	}	
}

void DSP::UpdateVertexTermRelation(int StartPos, int EndPos)
{
	int NumOfTerm = 0;
	for(int i=StartPos;i<=EndPos;i++)
	{
		int VIdx = m_pXOrder[i];
		NumOfTerm += m_pVertex2Term[VIdx].Len;		
	}	

	int* pTermIdx = new int[NumOfTerm];
	int ptr = 0;
	for(int i=StartPos;i<=EndPos;i++)
	{
		int VIdx = m_pXOrder[i];
		for(int j=0;j<m_pVertex2Term[VIdx].Len;j++)
		{
			int TIdx = m_pVertex2Term[VIdx].pBuf[j];
			pTermIdx[ptr++] = TIdx;
		}

		m_pVertex2Term[VIdx].Len = 0;
	}		

	for(int i=0;i<NumOfTerm;i++)
	{
		int TIdx = pTermIdx[i];

		Term& term = m_pTerms[TIdx];
		int MaxIdx = -1;
		for(int k=0;k<term.NumElem;k++)
		{
			int curIdx = m_pInvXOrder[term.Vars[k]];									
			MaxIdx = MaxIdx>curIdx?MaxIdx:curIdx;
		}

		FLenBuf& Flb = m_pVertex2Term[m_pXOrder[MaxIdx]];
		Flb.pBuf[Flb.Len++] = TIdx;		
	}

	delete[] pTermIdx;
}

int DSP::MinPartition(int StartPos, int EndPos, SubPermutation*** pppOutKTs)
{
	int Num = EndPos - StartPos + 1;	
	double c = 0;
	for(int i=0;i<Num;i++)
	{
		c += m_pRewards[StartPos+i];
		m_pDoubleBuf1[i] = c;
	}	

	int sptr = StartPos;
	int numptr = 0;
	do
	{
		int maxPos = sptr;
		double maxVal = m_pDoubleBuf1[sptr-StartPos];
		int Count = 1;
		for(int i=sptr+1;i<=EndPos;i++)
		{
			Count++;
			double val = m_pDoubleBuf1[i-StartPos]/Count;
			if(val>=maxVal)
			{
				maxVal = val;
				maxPos = i;
			}
		}

		m_pIntBuf1[numptr] = maxPos;
		m_pDoubleBuf2[numptr] = maxVal;
		numptr++;		
		if(maxPos==EndPos)
			break;

		sptr = maxPos + 1;
		double c = m_pDoubleBuf1[maxPos-StartPos];
		for(int i=sptr;i<=EndPos;i++)
			m_pDoubleBuf1[i-StartPos] -= c;
	}while(true);

	*pppOutKTs = new SubPermutation*[numptr];	
	for(int i=0;i<numptr;i++)
	{
		SubPermutation* pKT = new SubPermutation;
		if(i==0)
			pKT->StartPos = StartPos;
		else
			pKT->StartPos = m_pIntBuf1[i-1] + 1;
		pKT->EndPos = m_pIntBuf1[i];
		pKT->NumVars = pKT->EndPos - pKT->StartPos + 1;
		pKT->AveReward = m_pDoubleBuf2[i];
		pKT->CanPartition = true;	
		(*pppOutKTs)[i] = pKT;
	}

	return numptr;
}

int DSP::CIP(int StartPos, int EndPos, SubPermutation*** pppOutKTs)
{
	*pppOutKTs = NULL;
	int Num = EndPos - StartPos + 1;

	struct INode
	{
		int I;
		INode* pNext;
	};

	INode* pNodeVec = new INode[Num];
	INode** pPtrVec = new INode*[Num];
	for(int i=0;i<Num;i++)
	{
		m_pIntBuf1[i] = i;
		pNodeVec[i].I = i;
		pNodeVec[i].pNext = NULL;
		pPtrVec[i] = &pNodeVec[i];
	}

	for(int i=0;i<Num;i++)
	{
		int VIdx = m_pXOrder[StartPos+i];
		for(int j=0;j<m_pVertex2Term[VIdx].Len;j++)
		{
			int TIdx = m_pVertex2Term[VIdx].pBuf[j];
			Term& term = m_pTerms[TIdx];
			int num = 0;
			for(int k=0;k<term.NumElem;k++)
			{
				int curIdx = m_pInvXOrder[term.Vars[k]];
				curIdx -= StartPos;
				if(curIdx<0)
					continue;
				int Pos = m_pIntBuf1[curIdx];
				bool IsExist = false;
				for(int l=0;l<num;l++)
				{
					if(m_pIntBuf2[l]==Pos)
					{
						IsExist = true;
						break;
					}
				}

				if(!IsExist)
					m_pIntBuf2[num++] = Pos;
			}

			if(num==1)
				continue;	

			int CPos = m_pIntBuf2[0];
			INode* ptr = pPtrVec[CPos];
			while(ptr->pNext!=NULL)
				ptr = ptr->pNext;
			for(int k=1;k<num;k++)
			{
				int curPos = m_pIntBuf2[k];
				ptr->pNext = pPtrVec[curPos];
				pPtrVec[curPos] = NULL;
				ptr = ptr->pNext;
				while(ptr->pNext!=NULL)
				{
					m_pIntBuf1[ptr->I] = CPos;
					ptr = ptr->pNext;
				}
				m_pIntBuf1[ptr->I] = CPos;
			}			
		}
	}

	int CCCount = 0;
	for(int i=0;i<Num;i++)
	{
		if(pPtrVec[i] == NULL)
			continue;

		int num = 0;
		INode* ptr = pPtrVec[i];
		while(ptr!=NULL)
		{			
			num++;
			ptr = ptr->pNext;
		}

		IntDouble Id;
		Id.I = i;
		Id.D = num;
		m_pIDBuf[CCCount++] = Id;
	}

	if(CCCount==1)
	{
		delete[] pPtrVec;
		delete[] pNodeVec;
		return 1;
	}

	qsort(m_pIDBuf,CCCount,sizeof(IntDouble),compareID);	
	int idxptr = 0;
	for(int i=0;i<CCCount;i++)
	{	
		IntDouble& Id = m_pIDBuf[i];
		INode* ptr = pPtrVec[Id.I];
		while(ptr!=NULL)
		{			
			m_pIntBuf1[idxptr++] = m_pXOrder[StartPos+ptr->I];
			ptr = ptr->pNext;
		}

		m_pIntBuf2[i] = StartPos + idxptr-1;
	}

	delete[] pPtrVec;
	delete[] pNodeVec;	

	UpdateOrder(StartPos,EndPos,m_pIntBuf1);

	*pppOutKTs = new SubPermutation*[CCCount];	
	for(int i=0;i<CCCount;i++)
	{
		SubPermutation* pKT = new SubPermutation;
		if(i==0)
			pKT->StartPos = StartPos;
		else
			pKT->StartPos = m_pIntBuf2[i-1] + 1;
		pKT->EndPos = m_pIntBuf2[i];
		pKT->NumVars = pKT->EndPos - pKT->StartPos + 1;
		pKT->AveReward = 0;		
		(*pppOutKTs)[i] = pKT;
	}

	return CCCount;		
}


// Partition a maximal min-sub-permutation. First, use a herustic but fast algorithm. 
// If not succeed, then use the QPBO algorithm to precisely do it.
int DSP::ReOrderVerticesWithinMMSP(SubPermutation* pInKT,SubPermutation*** pppOutKTs)
{	
	*pppOutKTs = NULL;
	int StartPos = pInKT->StartPos;
	int EndPos   = pInKT->EndPos;
	int NumOfOriVars = EndPos - StartPos + 1;

	printf("NumOfOriVars:%d\n",NumOfOriVars);	

	if(NumOfOriVars==1)
		return 1;

	double ret = -1;
	if(NumOfOriVars>m_KeyNumber)	
		ret = GreedyOptimalOrder(StartPos,EndPos,m_pIntBuf1,m_pDoubleBuf1);

	int NumOfKT = 1;
	if(ret>(1+m_RelEps)*pInKT->AveReward)
	{
		for(int i=StartPos;i<=EndPos;i++)
		{
			int NewIdx = m_pIntBuf1[i-StartPos];
			m_pXOrder[i] = NewIdx;
			m_pInvXOrder[NewIdx] = i;
			m_pRewards[i] = m_pDoubleBuf1[i-StartPos];
		}
		UpdateVertexTermRelation(StartPos,EndPos);		

		NumOfKT = MinPartition(StartPos,EndPos,pppOutKTs);
		if(NumOfKT==1)			
		{
			delete (*pppOutKTs)[0];
			delete[] (*pppOutKTs);
			(*pppOutKTs) = NULL;			
		}
	}

	if(NumOfKT==1)
	{
		struct PairwiseTerm
		{
			int Idx1,Idx2;
			double c;
		};

		int MaxNumOfAulVars, MaxNumOfPairwiseTerm;
		MaxNumOfAulVars = 0;
		MaxNumOfPairwiseTerm = 0;

		for(int i=StartPos;i<=EndPos;i++)
		{
			int VIdx = m_pXOrder[i];
			for(int j=0;j<m_pVertex2Term[VIdx].Len;j++)
			{ 
				int TIdx = m_pVertex2Term[VIdx].pBuf[j];
				Term& term = m_pTerms[TIdx];
				MaxNumOfAulVars++;
				MaxNumOfPairwiseTerm += term.NumElem;
			}
		}

		double* pUTerms = new double[NumOfOriVars+MaxNumOfAulVars];
		PairwiseTerm* pPTerms = new PairwiseTerm[MaxNumOfPairwiseTerm];

		double MinusAve = -1*pInKT->AveReward;
		for(int i=0;i<NumOfOriVars;i++)
			pUTerms[i] = MinusAve;

		int CurNumOfAulVars = 0;
		int CurNumOfPairTerm = 0;

		for(int i=StartPos;i<=EndPos;i++)
		{
			int VIdx = m_pXOrder[i];
			for(int j=0;j<m_pVertex2Term[VIdx].Len;j++)
			{ 
				int TIdx = m_pVertex2Term[VIdx].pBuf[j];
				Term& term = m_pTerms[TIdx];
				int MaxPos = -1;
				int ptr = 0;
				for(int k=0;k<term.NumElem;k++)
				{
					int curIdx = m_pInvXOrder[term.Vars[k]];
					if(curIdx<StartPos)
						continue;
					MaxPos = MaxPos>curIdx?MaxPos:curIdx;
					m_pIntBuf1[ptr++] = curIdx;					
				}

				if(ptr==1)
					pUTerms[MaxPos-StartPos] += term.c;
				else
				{
					pUTerms[NumOfOriVars+CurNumOfAulVars] = term.c*(1-ptr);
					CurNumOfAulVars++;

					int Idx1 = NumOfOriVars + CurNumOfAulVars -1;
					for(int k=0;k<ptr;k++)
					{
						pPTerms[CurNumOfPairTerm].c = term.c;
						pPTerms[CurNumOfPairTerm].Idx1 = Idx1;
						pPTerms[CurNumOfPairTerm].Idx2 = m_pIntBuf1[k] - StartPos;
						CurNumOfPairTerm++;
					}
				}
			}
		}
		
		/*************************** QPBO *******************************************************************************************/

		int NumOfVars = NumOfOriVars+CurNumOfAulVars;
		int NumOfEdge = CurNumOfPairTerm;
		
		printf("QPBO: V:%d E:%d\n",NumOfVars,NumOfEdge);		

		typedef int REAL;
		QPBO<REAL>* q = new QPBO<REAL>(NumOfVars,2*NumOfEdge);
		q->AddNode(NumOfVars);

		for(int i=0;i<NumOfVars;i++)
			q->AddUnaryTerm(i,0,(int)floor(-1*pUTerms[i]*m_RoundInteger));		

		for(int i=0;i<CurNumOfPairTerm;i++)
		{
			PairwiseTerm& pt = pPTerms[i];
			q->AddPairwiseTerm(pt.Idx1,pt.Idx2,0,0,0,(int)floor(-1*pt.c*m_RoundInteger));		
		}

		delete[] pUTerms;
		delete[] pPTerms;

		q->Solve();
		q->ComputeWeakPersistencies();	
		
		int num = 0;
		for(int i=0;i<NumOfOriVars;i++)
		{
			int l = q->GetLabel(i);
			if(l==1)			
				m_pIntBuf1[num++] = m_pXOrder[i+StartPos];				
		}		
		
		printf("QPBO: NumSel:%d\n",num);
		
		if((num==0)||(num==NumOfOriVars))
			return 1;
		for(int i=0;i<NumOfOriVars;i++)
		{
			int l = q->GetLabel(i);
			if(l==0)			
				m_pIntBuf1[num++] = m_pXOrder[i+StartPos];				
		}

		delete q;

		//************************** Reorder Variables ************************************************
		UpdateOrder(StartPos,EndPos,m_pIntBuf1);		

		// min partition
		NumOfKT = MinPartition(StartPos,EndPos,pppOutKTs);
		
		if(NumOfKT==1)
		{
			delete (*pppOutKTs)[0];
			delete[] (*pppOutKTs);
			(*pppOutKTs) = NULL;			
		}
	}

	return NumOfKT;
}

void DSP::MinMerge()
{
	while(true)
	{
		bool IsMerge = false;
		SubPermutation* pStart = m_pHead;
		SubPermutation* pKT = pStart;
		int Num = 1;
		while(pKT!=NULL)
		{
			if((pKT->pNext==NULL)||(pKT->pNext->AveReward<pKT->AveReward))
			{
				// merge
				if(Num>1)
				{
					IsMerge = true;

					double tw = 0;
					int tc = 0;
					SubPermutation* pTemp = pStart;
					while(pTemp!=pKT->pNext)
					{
						tw += pTemp->NumVars * pTemp->AveReward;
						tc += pTemp->NumVars;
						pTemp = pTemp->pNext;
					}					

					pTemp = pStart->pNext;
					pStart->EndPos = pKT->EndPos;
					pStart->NumVars = tc;
					pStart->AveReward = tw/tc;
					pStart->CanPartition = true;
					pStart->pNext = pKT->pNext;	

					if(pKT->pNext!=NULL)
					{
						pKT->pNext->pPre = pStart;
						pKT->pNext = NULL;
					}

					// delete
					while(pTemp!=NULL)
					{
						SubPermutation* pCur = pTemp;
						pTemp = pTemp->pNext;
						delete pCur;
					};	

					pKT = pStart;					
				}

				pStart = pKT->pNext;
				Num = 1;
			}
			else
				Num++;

			pKT = pKT->pNext;
		}//end while

		if(!IsMerge)
			break;
	}//end while
}

void DSP::Solve()
{
	Init();
	SubPermutation** ppKTs;
	int NumOfKT = MinPartition(0,m_NumVar-1,&ppKTs);
	m_pHead = ppKTs[0];
	m_pHead->pPre = NULL;
	SubPermutation* ptr = m_pHead;
	for(int i=1;i<NumOfKT;i++)
	{
		ptr->pNext = ppKTs[i];
		ptr->pNext->pPre = ptr;
		ptr = ptr->pNext;
	}
	ptr->pNext = NULL;

	// second, iterate partition and min-merge
	while(true)
	{
		// try to paritition
		bool IsPartitioned = false;
		ptr = m_pHead;
		while(ptr!=NULL)
		{
			if(ptr->CanPartition)
			{				
				int  NumOfKT = ReOrderVerticesWithinMMSP(ptr,&ppKTs);
				if(NumOfKT>1)
				{
					IsPartitioned = true;

					SubPermutation* pPre = ptr->pPre;
					SubPermutation* pNext = ptr->pNext;
					delete ptr;
					ptr = ppKTs[0];

					if(pPre==NULL)
					{
						m_pHead = ptr;
						m_pHead->pPre = NULL;						
					}
					else
					{
						pPre->pNext = ptr;
						ptr->pPre = pPre;
					}

					for(int i=1;i<NumOfKT;i++)
					{
						ptr->pNext = ppKTs[i];
						ptr->pNext->pPre = ptr;
						ptr = ptr->pNext;
					}

					ptr->pNext = pNext;	
					if(pNext!=NULL)
						pNext->pPre = ptr;
				}
				else
					ptr->CanPartition = false;
			}			

			ptr = ptr->pNext;
		}

		// already finish
		if(!IsPartitioned)
			break;

		// try to merge
		MinMerge();
	}

	//assign sigature to each maximal min-sub-permutation
	int SIdx = 0;
	ptr = m_pHead;
	while(ptr!=NULL)
	{
		ptr->Singature = SIdx++;
		ptr = ptr->pNext;
	}

	// finally, get all indepdent components
	ptr = m_pHead;
	while(ptr!=NULL)
	{
		int NumOfCC = CIP(ptr->StartPos,ptr->EndPos,&ppKTs);
		if(NumOfCC>1)
		{
			SubPermutation* pPre = ptr->pPre;
			SubPermutation* pNext = ptr->pNext;
			int SIdx = ptr->Singature;
			delete ptr;

			for(int i=0;i<NumOfCC;i++)
				ppKTs[i]->Singature = SIdx;

			ptr = ppKTs[0];
			
			if(pPre==NULL)
			{
				m_pHead = ptr;
				m_pHead->pPre = NULL;						
			}
			else
			{
				pPre->pNext = ptr;
				ptr->pPre = pPre;
			}

			for(int i=1;i<NumOfCC;i++)
			{
				ptr->pNext = ppKTs[i];
				ptr->pNext->pPre = ptr;
				ptr = ptr->pNext;				
			}

			ptr->pNext = pNext;	
			if(pNext!=NULL)
				pNext->pPre = ptr;
		}
		ptr = ptr->pNext;
	}	
}

