function [V] = spectral_embedding(W,K)

W = (W+W')/2;

% compute normalized laplacian graph
D = diag(sum(W,1) + eps);
invSqrtD = sqrt(inv(abs(D)));
L = invSqrtD * W * invSqrtD - eye(size(W));      
L = (L + L')/2;    
opts.disp = 0;
[V ~] = eigs(L,K,'LA',opts);

% compute L2 norm for V
normMat = repmat(sqrt(sum(V.*V,2)),1,size(V,2));
normMat(normMat==0)=1;
V = V./normMat;


