%This is the demo code for the paper: 
%Transductive Domain Adaptation with Affinity Learning. 
%Le Shu and Longin Jan Latecki 
%The 24th ACM International Conference on Information and Knowledge Management (CIKM), Melbourne, Australia, 2015.

clear; clc; close all;

%% load data
load Caltech10_webcam.mat;

nS = size(xS,1);
nT = size(xT,1);

% parameter tuning
para.p = 8;     %  range (5 ~ 10)
para.iter = 10; %  not sensitive
para.K = 10;    %  range (10 ~ 20)  

%% baseline
model = svmtrain(yS,xS,'-t 0 -q');
[~, acc,~] = svmpredict(yT,xT, model, '-q');
fprintf('baseline method: acc = %f. \n', acc(1));

%% our method 

% construct cross domain graph
W = construct_W(xS,xT,yS,para.p);

% affinity learning
W = affinity_learning(W, para.iter);

% spectral embedding
V = spectral_embedding(W,para.K);

% classification
model = svmtrain(yS,V(1:nS,:),'-t 0 -q');
[~, acc,~] = svmpredict(yT,V(nS+1:end,:), model, '-q');
fprintf('our method: acc = %f. \n', acc(1));
