%Cross-Domain Graph ConStruction
%Input:  xS, source data, xT, target data, yS, source label.
%Output: W: transition matrix associated with Cross-domain graph

function W = construct_W(xS,xT,yS,K)

nS = size(xS,1);
nT = size(xT,1);

%%  construct the graph use cosin similarity
X = [xS ; xT];
normX = sqrt(sum(X .^ 2, 2));
W = (X * X') ./ (normX * normX');
W = abs(W);

%%  similarity adjustment

% step(1): add supervise information
uniqueC = unique(yS);
for i = 1 : length(uniqueC)
    idx = find(yS == uniqueC(i));
    W(idx,setdiff(1:nS,idx)) = 0;
    W(setdiff(1:nS,idx),idx) = 0;
end
%W = (W + W')/2;

% step(2): select source and target KNN neighbors for each node
[~,IW] = sort(W, 2,'descend');
newW = zeros(nS+nT,nS+nT);
for k = 1 : (nS + nT)
     % KNN indices
     row = IW(k, :);
     srcRow = row(row <= nS);
     tarRow = row(row > nS);
     srcK = srcRow(1:K);
     tarK = tarRow(1:K);
     newW(k, srcK) = W(k, srcK);
     newW(srcK, k) = newW(k, srcK);
     newW(k, tarK) = W(k, tarK);
     newW(tarK, k) = newW(k, tarK);
end
W = newW;

% step(3): reweight edges
beta  = (2 * nS * nT) / (nS * nS + nT * nT);
for k = 1:(nS+nT)
    % normalize intra- and inter - domain edges separately
      W(k,1:nS)  = W(k,1:nS) / (sum(W(k,1:nS)) + eps);
      W(k,nS+1:end)  = W(k,nS+1:end) / (sum(W(k,nS+1:end)) + eps);
    % reweight inter-domain edges
      if ( k <= nS )
          W(k,nS+1:end) = W(k,nS+1:end) * beta;
      else
          W(k,1:nS) = W(k,1:nS) * beta;
      end
end
