addpath ../../../Common/;
addpath ../../;
clear all;


ni = 30;
npo = 30;
nqo = 30;
np = 2*ni + npo;
nq = 3*ni + nqo;
sigma = 5;
sigmad = 5;
n = np*nq;
K1 = ni;
K2 = 200;
K3 = 1000;

d  = 256*sqrt(nq/10);
P1 = d*rand(ni,2);
Q1 = P1 + sigma*randn(ni,2);
Q2 = 0.5*(P1 + sigma*randn(ni,2));
P2 = d*rand(ni,2);
Q3 = 2*(P2+sigma*randn(ni,2));

Po = rand(npo,2)*d;
Qo = rand(nqo,2)*d;

P = [P1;P2;Po];
Q = [Q1;Q2;Q3;Qo];

subplot(2,2,1);
plot(P1(:,1),P1(:,2),'r.');
hold on;
plot(P2(:,1),P2(:,2),'g*');
hold on;
plot(Po(:,1),Po(:,2),'bx');
xlabel('x');
ylabel('y');

subplot(2,2,2);
plot(Q1(:,1),Q1(:,2),'r.');
hold on;
plot(Q2(:,1),Q2(:,2),'r+');
hold on;
plot(Q3(:,1),Q3(:,2),'g*');
hold on;
plot(Qo(:,1),Qo(:,2),'bx');
xlabel('x');
ylabel('y');


%%%GroundTruth
BaseCor1 = [];
BaseCor2 = [];
BaseCor3 = [];
for i=1:ni
    BaseCor1 = [BaseCor1;(i-1)*nq+i];
    BaseCor2 = [BaseCor2;(i-1)*nq+ni+i];
    BaseCor3 = [BaseCor3;(i+ni-1)*nq+2*ni+i];   
end;

CorrectArray = [];
FValueArray  = [];
for s = 0.3:0.1:3    
    Para = [];
    Para(1) = sigmad;
    Para(2) = s;
    M = ScaleAffinityMatrixSparse(P,Q,Para);
    
    %%Shift from every vertices
    StartPoints = [];
    for i=1:n
        StartPoints{i} = [i,1];
    end;
    StartPoints = StartPoints';

    K1 = ni;
    Neighbor = [];
    Para = [];
    Para(1) = n;
    Para(2) = K1;
    Para(3) = 0.1/ni;
    Para(4) = 0.00001;
    Para(5) = 0.0001;
    Para(6) = 0.000000000000001;   
    [Maxima,Support,FValue] = SEA(M,Neighbor,StartPoints,Para');
    
    %%Select K2 largest KKT points
    [Y,I] = sort(FValue,'descend');
    SelectSupport = [];
    SelectMaxima  = [];
    for i=1:K2
        SelectSupport{i} = Support{I(i)};
        SelectMaxima{i}  = Maxima{I(i)};
    end;
    SelectSupport = SelectSupport';
    SelectMaxima  = SelectMaxima';

    Para(1) = n;
    DSs = RecoverDenseSubgraph(M,SelectSupport,SelectMaxima,Para);

    %%Find knn of these dense subgraphs
    Para = [];
    Para(1) = n;
    Para(2) = K3;
    NN = KNN(M,DSs,Para);   
    
    %%Recover correspondences
    CorrectCorArray = [];
    for i=1:K2   
      I = NN(:,i);
      Cors = ConstructCorrespondence(I,K3,np,nq);   
      CorrectCor1 = intersect(BaseCor1,Cors);
      NumOfCorrectCors1 = size(CorrectCor1,1);
      CorrectCor2 = intersect(BaseCor2,Cors);
      NumOfCorrectCors2 = size(CorrectCor2,1);
      CorrectCor3 = intersect(BaseCor3,Cors);
      NumOfCorrectCors3 = size(CorrectCor3,1);
      CorrectCorArray = [CorrectCorArray;[NumOfCorrectCors1,NumOfCorrectCors2,NumOfCorrectCors3]];
    end;    
    CorrectArray = [CorrectArray;max(CorrectCorArray)];   
    FValueArray  = [FValueArray;Y(1)];
end;

FinalNums = max(CorrectArray);
subplot(2,2,3);
bar(FinalNums);
xlabel('Index of Clusters');
ylabel('Number of correct matches');

subplot(2,2,4);
plot(0.3:0.1:3,FValueArray);

save multiscale.mat;
