clear all;
load One2TwoSameOutliers30Noise.mat;
AM1 = AveMatches;
Sd1 = StdDev;
X1  = Sigma;

load One2TwoOutliersNoise5.mat;
AM2 = AveMatches;
Sd2 = StdDev;
X2  = no;

load TwoOne2OneSameOutliers30Noise.mat;
AM3 = AveMatches;
Sd3 = StdDev;
X3  = Sigma;

load TwoOne2OneOutliersNoise5.mat;
AM4 = AveMatches;
Sd4 = StdDev;
X4  = no;

Lw = 2;
subplot(2,2,1);
plot(X1,AM1(:,1),'r','LineWidth',Lw);
hold on;
plot(X1,AM1(:,2),'b','LineWidth',Lw);
hold on;
plot(X1,AM1(:,1)-Sd1(:,1),'r:','LineWidth',Lw);
hold on;
plot(X1,AM1(:,2)-Sd1(:,2),'b:','LineWidth',Lw);
axis([1,20,0,30]);
xlabel('\sigma');
ylabel('Number of correct matches');
text(1,5,'Two One-to-One Clusters');
text(1,2,'30 Inliers + 30 Outliers');

subplot(2,2,2);
plot(X2,AM2(:,1),'r','LineWidth',Lw);
hold on;
plot(X2,AM2(:,2),'b','LineWidth',Lw);
hold on;
plot(X2,AM2(:,1)-Sd2(:,1),'r:','LineWidth',Lw);
hold on;
plot(X2,AM2(:,2)-Sd2(:,2),'b:','LineWidth',Lw);
axis([30,70,0,30]);
xlabel('Number of outliers');
ylabel('Number of correct matches');
text(30,5,'Two One-to-One Clusters');
text(30,2,'\sigma = 5');


subplot(2,2,3);
plot(X3,AM3(:,1),'r','LineWidth',Lw);
hold on;
plot(X3,AM3(:,2),'b','LineWidth',Lw);
hold on;
plot(X3,AM3(:,1)-Sd3(:,1),'r:','LineWidth',Lw);
hold on;
plot(X3,AM3(:,2)-Sd3(:,2),'b:','LineWidth',Lw);
axis([1,20,0,30]);
xlabel('\sigma');
ylabel('Number of correct matches');
text(1,5,'One-to-Two cluster');
text(1,2,'30 Inliers + 30 Outliers');

subplot(2,2,4);
plot(X4,AM4(:,1),'r','LineWidth',Lw);
hold on;
plot(X4,AM4(:,2),'b','LineWidth',Lw);
hold on;
plot(X4,AM4(:,1)-Sd4(:,1),'r:','LineWidth',Lw);
hold on;
plot(X4,AM4(:,2)-Sd4(:,2),'b:','LineWidth',Lw);
axis([30,70,0,30]);
xlabel('Number of outliers');
ylabel('Number of correct matches');
text(30,5,'One-to-Two Cluster');
text(30,2,'\sigma = 5');


