addpath ../../../Common/;
addpath ../../;
clear all;

ni = 30;
Times = 30;
Sigmad = 5;
Sigma  = 5;
K2 = 200;
K3 = 1000;

AveMatches=[];
Sd = [];

for no = 30:10:70
    CorrectNums = [];    
    for i=1:Times
        CurCorrectNum = OneExpSEA1(ni,no,no,Sigma,Sigmad,K2,K3);
        CorrectNums =[CorrectNums;CurCorrectNum];
    end;
    Avm = sum(CorrectNums)/Times;
    AveMatches =[AveMatches;Avm];
    StdDev = std(CorrectNums);
    Sd = [Sd;StdDev];    
end;

no = 30:10:70;

plot(no,AveMatches(:,1),'r','LineWidth',2);
hold on;
plot(no,AveMatches(:,2),'b','LineWidth',2);
hold on;
plot(no,AveMatches(:,1)-Sd(:,1),'r:','LineWidth',2);
hold on;
plot(no,AveMatches(:,2)-Sd(:,2),'b:','LineWidth',2);
axis([30,70,0,ni]);

save TwoOne2OneOutliersNoise5.mat;