clear all;
load I10-60OISd5S5.mat;
MR  = MatchingRate;
Ad1  = AveDev;

load I30O30Sd1-20S5.mat;
AM  = AveMatches;
Ad2 = AveDev;

load TimeComplexity;
n = ni+no;
n = n';
n = n.*n;
E2A = Entry2Array./n;
AveTime = TimeArray(:,2)./n;

Lw = 2;
subplot(2,2,1);
plot(Inliers,MR(:,1),'b','LineWidth',Lw);
hold on;
plot(Inliers,MR(:,2),'r','LineWidth',Lw);
hold on;
plot(Inliers,MR(:,3),'g','LineWidth',Lw);
hold on;
plot(Inliers,Ad1(:,1),'b:','LineWidth',Lw);
hold on;
plot(Inliers,Ad1(:,2),'r:','LineWidth',Lw);
hold on;
plot(Inliers,Ad1(:,3),'g:','LineWidth',Lw);
axis([10,60,0,1]);
xlabel('Number of inliers and outliers');
ylabel('Matching Rate');
text(10.1,0.15,'\sigma = 5');
text(10.1,0.05,'\sigmad = 5');

subplot(2,2,2);
plot(ThreshSigma,AM(:,1),'b','LineWidth',2);
hold on;
plot(ThreshSigma,AM(:,2),'r','LineWidth',2);
hold on;
plot(ThreshSigma,AM(:,3),'g','LineWidth',2);
hold on;
plot(ThreshSigma,Ad2(:,1),'b:','LineWidth',2);
hold on;
plot(ThreshSigma,Ad2(:,2),'r:','LineWidth',2);
hold on;
plot(ThreshSigma,Ad2(:,3),'g:','LineWidth',2);
axis([1,20,0,30]);
xlabel('\sigma_d');
ylabel('Number of correct matches');
text(1,1,'\sigma = 5');

subplot(2,2,3);
semilogy(no,TimeArray(:,1),'b','LineWidth',2);
hold on;
semilogy(no,TimeArray(:,2),'r','LineWidth',2);
hold on;
semilogy(no,TimeArray(:,3),'g','LineWidth',2);
hold on;
semilogy(no,AveTime,'magenta','LineWidth',2);
axis([10,100,0,100]);
xlabel('Number of outliers');
ylabel('Time (seconds)');
text(11,0.005,'\sigma = 5');
text(11,0.001,'\sigma_d = 5');

subplot(2,2,4);
semilogy(no,Entry2Array,'b','LineWidth',2);
hold on;
semilogy(no,E2A,'r','LineWidth',2);
axis([10,100,0,1e7]);
xlabel('Number of outliers');
ylabel('Number of edges');
text(11,400,'\sigma = 5');
text(11,100,'\sigma_d = 5');












