addpath ../../../Common/;
addpath ../../;
clear all;



ni = 30;
npo = 30;
nqo = 30;
Times = 30;
Sigma = 5;
K2 = 200;
K3 = 1000;

AveMatches= [];
Sd = [];
ThreshSigma=[];
for Sigmad=1:1:20
    CorrectNums = [];    
    for i=1:Times
        CurCorrectNum = OneExpThree(ni,npo,nqo,Sigma,Sigmad,K2,K3);
        CorrectNums =[CorrectNums;CurCorrectNum];
    end;
    Avm = sum(CorrectNums)/Times;    
    AveMatches =[AveMatches;Avm];
    StdDev = std(CorrectNums);
    Sd = [Sd;StdDev];
    ThreshSigma = [ThreshSigma;Sigmad];
end;

AveDev = AveMatches - Sd;

%%plot result
plot(ThreshSigma,AveMatches(:,1),'b','LineWidth',2);
hold on;
plot(ThreshSigma,AveMatches(:,2),'r','LineWidth',2);
hold on;
plot(ThreshSigma,AveMatches(:,3),'g','LineWidth',3);
hold on;
plot(ThreshSigma,AveDev(:,1),'b:','LineWidth',2);
hold on;
plot(ThreshSigma,AveDev(:,2),'r:','LineWidth',2);
hold on;
plot(ThreshSigma,AveDev(:,3),'g:','LineWidth',2);
axis([0,20,0,ni]);

save I30O30Sd1-20S5.mat;