addpath ../../../Common/;
addpath ../../;
clear all;


Times = 30;
Sigmad = 5;
Sigma = 5;
K2 = 200;
K3 = 1000;

MatchingRate = [];
Sd = [];
Inliers = [];
for ni=10:5:60   
    CorrectNums = [];    
    for i=1:Times
        CurCorrectNum = OneExpThree(ni,ni,ni,Sigma,Sigmad,K2,K3);
        CorrectNums =[CorrectNums;CurCorrectNum];
    end;    
    CorrectNums = CorrectNums/ni;
    Avm = sum(CorrectNums)/Times;  
    MatchingRate = [MatchingRate;Avm];
    StdDev = std(CorrectNums);
    Sd = [Sd;StdDev];
    Inliers = [Inliers;ni];
end;

AveDev = MatchingRate - Sd;

%%plot result
plot(Inliers,MatchingRate(:,1),'b','LineWidth',2);
hold on;
plot(Inliers,MatchingRate(:,2),'r','LineWidth',2);
hold on;
plot(Inliers,MatchingRate(:,3),'g','LineWidth',2);
hold on;
plot(Inliers,AveDev(:,1),'b:','LineWidth',2);
hold on;
plot(Inliers,AveDev(:,2),'r:','LineWidth',2);
hold on;
plot(Inliers,AveDev(:,3),'g:','LineWidth',2);
axis([10,60,0,1]);

save I10-60OISd5S5.mat;