clear all;
load I30O0Sd5S0-20.mat;
AM1 = AveMatches;
S1 = Sd;

load I30O30Sd5S0-20.mat;
AM2 = AveMatches;
S2 = Sd;

load I30O0-100Sd5S0.mat;
AM3 = AveMatches;
S3 = Sd;

load I30O0-100Sd5S4.mat;
AM4 = AveMatches;
S4 = Sd;

NoiseSigma = 0:20;
NoiseSigma = NoiseSigma';
Lw = 2;
Fw = 30;
subplot(2,2,1);
plot(NoiseSigma,AM1(:,1),'b','LineWidth',Lw);
hold on;
plot(NoiseSigma,AM1(:,2),'r','LineWidth',Lw);
hold on;
plot(NoiseSigma,AM1(:,3),'g','LineWidth',Lw);
hold on;
plot(NoiseSigma,AM1(:,1)-S1(:,1),'b:','LineWidth',Lw);
hold on;
plot(NoiseSigma,AM1(:,2)-S1(:,2),'r:','LineWidth',Lw);
hold on;
plot(NoiseSigma,AM1(:,3)-S1(:,3),'g:','LineWidth',Lw);
axis([0,20,0,30]);
xlabel('Deformation Noise \sigma');
ylabel('Number of correct matches');
text(0.2,5,'n_P=30');
text(0.2,3,'n_Q=30');
text(0.2,1,'No outliers');



subplot(2,2,2);
plot(NoiseSigma,AM2(:,1),'b','LineWidth',Lw);
hold on;
plot(NoiseSigma,AM2(:,2),'r','LineWidth',Lw);
hold on;
plot(NoiseSigma,AM2(:,3),'g','LineWidth',Lw);
hold on;
plot(NoiseSigma,AM2(:,1)-S2(:,1),'b:','LineWidth',Lw);
hold on;
plot(NoiseSigma,AM2(:,2)-S2(:,2),'r:','LineWidth',Lw);
hold on;
plot(NoiseSigma,AM2(:,3)-S2(:,3),'g:','LineWidth',Lw);
axis([0,20,0,30]);
xlabel('Deformation Noise \sigma');
ylabel('Number of correct matches');
text(0.2,3,'n_P=30 inliers + 30 outliers');
text(0.2,1,'n_Q=30 inliers + 30 oultiers');
legend('Spectral Method','Our method','Dominant Set');

no = 0:10:100;
subplot(2,2,3);
plot(no,AM3(:,1),'b','LineWidth',Lw);
hold on;
plot(no,AM3(:,2),'r','LineWidth',Lw);
hold on;
plot(no,AM3(:,3),'g','LineWidth',Lw);
hold on;
plot(no,AM3(:,1)-S3(:,1),'b:','LineWidth',Lw);
hold on;
plot(no,AM3(:,2)-S3(:,2),'r:','LineWidth',Lw);
hold on;
plot(no,AM3(:,3)-S3(:,3),'g:','LineWidth',Lw);
axis([0,100,0,30]);
xlabel('Number of outliers in both P and Q');
ylabel('Number of correct matches');
text(1,5,'n_P=30 inliers + outliers');
text(1,3,'n_Q=30 inliers + outliers');
text(1,1,'No Noise');

subplot(2,2,4);
plot(no,AM4(:,1),'b','LineWidth',Lw);
hold on;
plot(no,AM4(:,2),'r','LineWidth',Lw);
hold on;
plot(no,AM4(:,3),'g','LineWidth',Lw);
hold on;
plot(no,AM4(:,1)-S4(:,1),'b:','LineWidth',Lw);
hold on;
plot(no,AM4(:,2)-S4(:,2),'r:','LineWidth',Lw);
hold on;
plot(no,AM4(:,3)-S4(:,3),'g:','LineWidth',Lw);
axis([0,100,0,30]);
xlabel('Number of outliers in both P and Q');
ylabel('Number of correct matches');
text(1,5,'n_P=30 inliers + outliers');
text(1,3,'n_Q=30 inliers + outliers');
text(1,1,'\sigma = 4');
% 
% subplot(2,2,3);
% plot(no,AM3(:,1),'b','LineWidth',Lw);
% hold on;
% plot(no,AM3(:,2),'r','LineWidth',Lw);
% hold on;
% plot(no,AM3(:,1)-S3(:,1),'b:','LineWidth',Lw);
% hold on;
% plot(no,AM3(:,2)-S3(:,2),'r:','LineWidth',Lw);
% axis([0,60,0,16]);
% xlabel('Number of outliers in both P and Q');
% ylabel('Number of correct matches');
% text(1,5,'n_P=15+outliers');
% text(1,3,'n_Q=15+outliers');
% text(1,1,'\sigma=0');
% 
% subplot(2,2,4);
% plot(no,AM4(:,1),'b','LineWidth',Lw);
% hold on;
% plot(no,AM4(:,2),'r','LineWidth',Lw);
% hold on;
% plot(no,AM4(:,1)-S4(:,1),'b:','LineWidth',Lw);
% hold on;
% plot(no,AM4(:,2)-S4(:,2),'r:','LineWidth',Lw);
% axis([0,60,0,16]);
% xlabel('Number of outliers in both P and Q');
% ylabel('Number of correct matches');
% text(1,5,'n_P=15+outliers');
% text(1,3,'n_Q=15+outliers');
% text(1,1,'\sigma=4');


% load AveMatches;
% load Sd;
% AveDev = AveMatches - Sd;
% % NoiseSigma = 0.5:0.5:10;
% no=0:3:60
% 
% plot(no,AveMatches(:,1),'b','LineWidth',8);
% hold on;
% plot(no,AveMatches(:,2),'r','LineWidth',8);
% hold on;
% 
% plot(no,AveDev(:,1),'b-.','LineWidth',8);
% hold on;
% plot(no,AveDev(:,2),'r-.','LineWidth',8);
% axis([0,60,0,16]);
% 
%  FSize = 50;
%  h = gca;
%  set(h,'FontSize',FSize);
% title('Mean and std of the number of correct matches');
% xlabel('Deformation Noise \sigma');
% ylabel('Number of correct matches');
% 
% h = text(1,13,'n_p=30');
% set(h,'FontSize',FSize);
% h = text(1,9,'n_q=30');
% set(h,'FontSize',FSize);
% h = text(1,5,'No outliers');
% set(h,'FontSize',FSize);






