addpath ../../../Common/;
addpath ../../;
clear all;

ni = 30;
npo = 0;
nqo = 0;
Times = 30;
Sigmad = 5;
Sigma = 0;
K2 = 200;
K3 = 1000;

AveMatches= [];
Sd = [];
NumOutliers=[];
for no=0:10:100
    CorrectNums = [];    
    for i=1:Times
        CurCorrectNum = OneExpThree(ni,no,no,Sigma,Sigmad,K2,K3);
        CorrectNums =[CorrectNums;CurCorrectNum];
    end;
    Avm = sum(CorrectNums)/Times;    
    AveMatches =[AveMatches;Avm];
    StdDev = std(CorrectNums);
    Sd = [Sd;StdDev];
    NumOutliers = [NumOutliers;no];
end;

AveDev = AveMatches - Sd;

%%plot result
plot(NumOutliers,AveMatches(:,1),'b','LineWidth',2);
hold on;
plot(NumOutliers,AveMatches(:,2),'r','LineWidth',2);
hold on;
plot(NumOutliers,AveMatches(:,3),'g','LineWidth',2);
hold on;
plot(NumOutliers,AveDev(:,1),'b:','LineWidth',2);
hold on;
plot(NumOutliers,AveDev(:,2),'r:','LineWidth',2);
hold on;
plot(NumOutliers,AveDev(:,3),'g:','LineWidth',2);
axis([0,100,0,ni]);

save I30O0-100Sd5S0.mat;