addpath ../../../Common/;
addpath ../../;
clear all;

ni = 30;
npo = 30;
nqo = 30;
Times = 30;
Sigmad = 5;
K2 = 200;
K3 = 1000;

AveMatches= [];
AveTime = [];
Sd = [];
NoiseSigma=[];
for Sigma=0:1:20
    CorrectNums = [];  
    T = [];
    for i=1:Times
        [CurCorrectNum,TimeUsed] = OneExpThree(ni,npo,nqo,Sigma,Sigmad,K2,K3);
        CorrectNums =[CorrectNums;CurCorrectNum];
        T = [T;TimeUsed];
    end;
    Avm = sum(CorrectNums)/Times;    
    AveMatches =[AveMatches;Avm];
    AveTime = [AveTime;sum(T)/Times]; 
    StdDev = std(CorrectNums);
    Sd = [Sd;StdDev];
    NoiseSigma = [NoiseSigma;Sigma];
end;

AveDev = AveMatches - Sd;

%%plot result
plot(NoiseSigma,AveMatches(:,1),'b','LineWidth',2);
hold on;
plot(NoiseSigma,AveMatches(:,2),'r','LineWidth',2);
hold on;
plot(NoiseSigma,AveMatches(:,3),'g','LineWidth',2);
hold on;
plot(NoiseSigma,AveDev(:,1),'b:','LineWidth',2);
hold on;
plot(NoiseSigma,AveDev(:,2),'r:','LineWidth',2);
hold on;
plot(NoiseSigma,AveDev(:,3),'g:','LineWidth',2);
axis([0,20,0,ni]);

save I30O30Sd5S0-20.mat;