function [Ncc,TimeUsed,NumOfEntry1,NumOfEntry2] = OneExpThree(ni,npo,nqo,sigma,sigmad,K2,K3)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%  ni    : number of inliers
%%%%%%%% npo    : number of outliers in the first point set
%%%%%%%% nqo    : number of outliers in the second point set
%%%%%%%% sigma  : deformation parameter
%%%%%%%% sigmad : sensitivity parameter
%%%%%%%% K2    : the number of selected largest modes
%%%%%%%% K3    : the number of nearest neighbors for a mode
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%Generate two point sets
np = ni + npo;
nq = ni + nqo;
d  = 256*sqrt(nq/10);
Pi = rand(ni,2)*d;
Qi = Pi+ sigma*randn(ni,2);
Po = rand(npo,2)*d;
Qo = rand(nqo,2)*d;
P = [Pi;Po];
Q = [Qi;Qo];
n = np*nq;
if K3>n
    K3 = n;
end;

%%Rotation
alpha = 2*rand(1,1)*pi;
R = [cos(alpha),sin(alpha);-sin(alpha),cos(alpha)];
Q = Q*R;

%%Affinity Matrix
Para=[];
Para(1) = sigmad;
M1 = AffinityMatrix(P,Q,Para);
Para(2) = 1;
M2 = ScaleAffinityMatrixSparse(P,Q,Para);
NumOfEntry1 = size(M2,1);
Index = find(M2(:,3)>2.25);
NumOfEntry2 = size(Index,1);

%%Groundtruth
GroundCors=[];
for i=1:ni
    GroundCors =[GroundCors;(i-1)*nq+i];
end;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%Spectral Method%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%First Eigvector,make sure its sign is correct
tic;
opts.disp = 0;
[V,D]=eigs(M1,1,'LM',opts);
ESum = sum(V);
if ESum<0
    V=-V;   
end;
T = toc;

%%Recover correspondences
[Y,I] = sort(V,'descend');
Index = find(Y>1e-10); %%only deal with nozero elements
CurNum = size(Index,1);
Cors = ConstructCorrespondence(I(1:CurNum),CurNum,np,nq);
CorrectCor = intersect(GroundCors,Cors);
Ncc = size(CorrectCor,1);
TimeUsed = T;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%SEA%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%evolve from every vertices
StartPoints = [];
for i=1:n
    StartPoints{i} = [i,1];
end;
StartPoints = StartPoints';

K1 = ni;
Neighbor = [];
Para = [];
Para(1) = n;
Para(2) = K1;
Para(3) = 0.1/ni;
Para(4) = 0.00001;
Para(5) = 0.0001;
Para(6) = 0.000000000000001;
tic;
[Maxima,Support,FValue] = SEA(M2,Neighbor,StartPoints,Para');
T = toc;

%%Select K2 largest KKT points
[Y,I] = sort(FValue,'descend');
SelectSupport = [];
SelectMaxima  = [];
for i=1:K2
    SelectSupport{i} = Support{I(i)};
    SelectMaxima{i}  = Maxima{I(i)};
end;
SelectSupport = SelectSupport';
SelectMaxima  = SelectMaxima';

Para(1) = n;
DSs = RecoverDenseSubgraph(M2,SelectSupport,SelectMaxima,Para);

%%Find knn of these dense subgraphs
Para = [];
Para(1) = n;
Para(2) = K3;
NN = KNN(M2,DSs,Para);

%%Recover correspondences
CorrectCorArray = [];
for i=1:K2   
    I = NN(:,i);
    Cors = ConstructCorrespondence(I,K3,np,nq);   
    CorrectCor = intersect(GroundCors,Cors);
    NumOfCorrectCors = size(CorrectCor,1);
    CorrectCorArray = [CorrectCorArray;NumOfCorrectCors];
end;

Ncc =[Ncc,max(CorrectCorArray)];
TimeUsed = [TimeUsed,T];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%Replicator Equation%%%%%%%%%%%%%%%%%%%%%%
Para = [];
Para(1) = n;
Para(2) = 0.00001;
tic;
[Maxima,FValue] = ReplicatorEquation(M2,Para);
T = toc;

%%%Find knn of this KKT point
SelectedSupport = [];
SelectedMaxima  = [];
Sp = 1:n;
SelectedSupport{1} = Sp';
SelectedMaxima{1}  = Maxima;

Para(1) = n;
DSs = RecoverDenseSubgraph(M2,SelectedSupport,SelectedMaxima,Para);

Para = [];
Para(1) = n;
Para(2) = K3;
NN = KNN(M2,DSs,Para);

%%Recover correspondences
Cors = ConstructCorrespondence(NN(:,1),K3,np,nq);

CorrectCor = intersect(GroundCors,Cors);
Ncc = [Ncc, size(CorrectCor,1)];
TimeUsed = [TimeUsed,T];
