function Ncc = OneExpSEA2(ni,npo,nqo,sigma,sigmad,K2,K3)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%  ni    : number of inliers
%%%%%%%% npo    : number of outliers in the first point set
%%%%%%%% nqo    : number of outliers in the second point set
%%%%%%%% sigma  : deformation parameter
%%%%%%%% sigmad : sensitivity parameter
%%%%%%%% K2     : the number of selected largest modes
%%%%%%%% K3     : the number of nearest neighbors for a mode
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%Generate two point sets
np = ni + npo;
nq = 2*ni + nqo;
n  = np*nq;

d=256*sqrt(nq/10);
Pi  = rand(ni,2)*d;
Qi1 = Pi + sigma*randn(ni,2);
Qi2 = Pi + sigma*randn(ni,2);
Po = rand(npo,2)*d;
Qo = rand(nqo,2)*d;


%%Rotation
Alpha = 2*rand(1,1)*pi;
R = [cos(Alpha),sin(Alpha);-sin(Alpha),cos(Alpha)];
Qi1 = Qi1*R;

Alpha = 2*rand(1,1)*pi;
R = [cos(Alpha),sin(Alpha);-sin(Alpha),cos(Alpha)];
Qi2 = Qi2*R;

P = [Pi;Po];
Q = [Qi1;Qi2;Qo];

%%Groundtruth
GroundCors1=[];
for i=1:ni
    GroundCors1 =[GroundCors1;(i-1)*nq+i];
end;

GroundCors2=[];
for i=1:ni
    GroundCors2 =[GroundCors2;(i-1)*nq+i+ni];
end;

%%Affinity Matrix
Para=[];
Para(1) = sigmad;
Para(2) = 1;
M1 = ScaleAffinityMatrixSparse(P,Q,Para);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%   SEA  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%evolve from every vertices
StartPoints = [];
for i=1:n
    StartPoints{i} = [i,1];
end;
StartPoints = StartPoints';

K1 = ni;
Neighbor = [];
Para = [];
Para(1) = n;
Para(2) = K1;
Para(3) = 0.1/ni;
Para(4) = 0.00001;
Para(5) = 0.0001;
Para(6) = 0.000000000000001;
tic;
[Maxima,Support,FValue] = SEA(M1,Neighbor,StartPoints,Para');
T = toc;

%%Select K2 largest KKT points
[Y,I] = sort(FValue,'descend');
SelectSupport = [];
SelectMaxima  = [];
for i=1:K2
    SelectSupport{i} = Support{I(i)};
    SelectMaxima{i}  = Maxima{I(i)};
end;
SelectSupport = SelectSupport';
SelectMaxima  = SelectMaxima';

Para(1) = n;
DSs = RecoverDenseSubgraph(M1,SelectSupport,SelectMaxima,Para);

%%Find knn of these dense subgraphs
Para = [];
Para(1) = n;
Para(2) = K3;
NN = KNN(M1,DSs,Para);

%%Recover correspondences
CorrectCorArray1 = [];
CorrectCorArray2 = [];
for i=1:K2   
    I = NN(:,i);
    Cors = ConstructCorrespondence(I,K3,np,nq);   
    CorrectCor1 = intersect(GroundCors1,Cors);
    NumOfCorrectCors1 = size(CorrectCor1,1);
    CorrectCor2 = intersect(GroundCors2,Cors);
    NumOfCorrectCors2 = size(CorrectCor2,1);
    CorrectCorArray1 = [CorrectCorArray1;NumOfCorrectCors1];
    CorrectCorArray2 = [CorrectCorArray2;NumOfCorrectCors2];
end;
Ncc = [max(CorrectCorArray1),max(CorrectCorArray2)];



