clear all;
load Time1.mat;
X1 = X;
TA1 = TimeArray;
X11 = floor(X1/2);
X11 = [X11,X11];
CA1 = CorrectArray./X11;

load Time2.mat;
X2 = X;
TA2 = TimeArray;
CA2 = CorrectArray/20;

load Time3.mat;
X3 = X;
TA3 = TimeArray;
CA3 = CorrectArray/20;

Lw = 2;
subplot(2,3,1);
plot(X1,CA1(:,2),'b:','LineWidth', Lw);
hold on;
plot(X1,CA1(:,1),'r-','LineWidth', Lw);
axis([20,55,0,1.1]);
set(gca,'xtick',[20,30,40,50,55]);
set(gca,'ytick',0:0.2:1);
ylabel('Precision');
legend('Durand-Pasari','Our method');

text(20,0.4,'\alpha = 0.1');
text(20,0.2,'\beta = 0.2');

subplot(2,3,4);
semilogy(X1,TA1(:,2),'b:','LineWidth', Lw);
hold on;
semilogy(X1,TA1(:,1),'r-','LineWidth', Lw);
axis([20,55,0.001,100]);
set(gca,'xtick',[20,30,40,50,55]);
set(gca,'ytick',[0.001,0.1,1,10,100]);
xlabel('Number of vertices');
ylabel('Time (seconds)');
text(20,50,'\alpha = 0.1');
text(20,10,'\beta = 0.2');

subplot(2,3,2);
plot(X2,CA2(:,2),'b:','LineWidth', Lw);
hold on;
plot(X2,CA2(:,1),'r-','LineWidth', Lw);
axis([0.1,0.6,0,1.1]);
set(gca,'xtick',[0.1,0.2,0.3,0.4,0.5,0.6]);
set(gca,'ytick',0:0.2:1);
text(0.1,0.4,'n_1 = 40');
text(0.1,0.2,'n_2 = 20');


subplot(2,3,5);
semilogy(X2,TA2(:,2),'b:','LineWidth', Lw);
hold on;
semilogy(X2,TA2(:,1),'r-','LineWidth', Lw);
axis([0.1,0.6,0.01,10]);
set(gca,'xtick',[0.1,0.2,0.3,0.4,0.5,0.6]);
set(gca,'ytick',[0.01,0.1,1,10]);
xlabel('\alpha');
text(0.1,0.05,'n_1 = 40');
text(0.1,0.02,'n_2 = 20');

subplot(2,3,3);
plot(X3,CA3(:,2),'b:','LineWidth', Lw);
hold on;
plot(X3,CA3(:,1),'r-','LineWidth', Lw);
axis([0.1,0.8,0,1.1]);
set(gca,'xtick',[0.1,0.3,0.5,0.7,0.8]);
set(gca,'ytick',0:0.2:1);
text(0.1,0.4,'n_1 = 40');
text(0.1,0.2,'n_2 = 20');

subplot(2,3,6);
semilogy(X3,TA3(:,2),'b:','LineWidth', Lw);
hold on;
semilogy(X3,TA3(:,1),'r-','LineWidth', Lw);
axis([0.1,0.8,0.01,100]);
set(gca,'xtick',[0.1,0.3,0.5,0.7,0.8]);
set(gca,'ytick',[0.01,0.1,1,10,100]);
xlabel('\beta');
text(0.1,0.06,'n_1 = 40');
text(0.1,0.02,'n_2 = 20');

