clear all;
load Performance1.mat;
X1 = X;
CA1 = CorrectArray/50;
TA1 = TimeArray;


load Performance2.mat;
X2 = X;
CA2 = CorrectArray./X2;
TA2 = TimeArray;
Lw = 2;

subplot(1,2,1);
[AX1,H1,H2]=plotyy(X1,CA1,X1,TA1);
set(get(AX1(1),'Ylabel'),'String','Precision');
set(get(AX1(2),'Ylabel'),'String','Time (seconds)');
set(AX1(1),'YLim',[0.98,1.02]);
set(AX1(1),'YTick',0.98:0.01:1.02);
set(AX1(2),'YLim',[0,400]);
set(AX1(2),'YTick',0:50:400);
set(H1,'Color','r');
set(H1,'LineWidth',Lw);
set(H1,'LineStyle','-');
set(H2,'Color','b');
set(H2,'LineWidth',Lw);
set(H2,'LineStyle',':');
set(AX1(1),'XTick',[100,500,1000,1500,2000]);
set(AX1(1),'XLim',[100,2000]);
set(AX1(2),'XTick',[100,500,1000,1500,2000]);
set(AX1(2),'XLim',[100,2000]);
xlabel('n_1');
text(130,1.016,'\alpha = 0.1');
text(130,1.012,'\beta = 0.2');
text(130,1.007,'n_2=50');


subplot(1,2,2);
[AX2,H3,H4]=plotyy(X2,CA2,X2,TA2);
set(get(AX2(1),'Ylabel'),'String','Precision');
set(get(AX2(2),'Ylabel'),'String','Time (seconds)');
set(AX2(1),'YLim',[0.98,1.02]);
set(AX2(1),'YTick',0.98:0.01:1.02);
set(AX2(2),'YLim',[0,400]);
set(AX2(2),'YTick',0:50:400);
set(H3,'Color','r');
set(H3,'LineWidth',Lw);
set(H3,'LineStyle','-');
set(H4,'Color','b');
set(H4,'LineWidth',Lw);
set(H4,'LineStyle',':');
set(AX2(1),'XTick',50:50:300);
set(AX2(1),'XLim',[50,300]);
set(AX2(2),'XTick',50:50:300);
set(AX2(2),'XLim',[50,300]);
xlabel('n_2');
text(60,1.016,'\alpha = 0.1');
text(60,1.012,'\beta = 0.2');
text(60,1.007,'n_1=1000');

