function [CorrectNum, UsedTime] = OneExpGS(NumOfNode,NumOfCommon,Alpha,Belta,K2,K3)
%%%Generate two labeled graphs
Para(1) = NumOfNode;
Para(2) = NumOfCommon;
Para(3) = Alpha;
Para(4) = Belta;
[Label1,Adj1,Label2,Adj2,Permu] = GenRandGraph(Para);
Para(1) = 0.1;

%%%%Generate candidate correspondence and affinity matrix
[M,Mapping,Neighbor] = GenAffMatrixSparse(Label1,Adj1,Label2,Adj2,Para);

%%%GroundTruth
GroundCors = [];
for i=1:size(Mapping,1)
    if Mapping(i,1)>NumOfCommon
        continue;
    end;
    if Permu(Mapping(i,1),1)== Mapping(i,2)
       GroundCors = [GroundCors;i];
     end;    
end;

NumOfVertices = size(Mapping,1);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%  SEA  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%To avoid too large parameters
tic;
K1 = NumOfCommon;
if K2>NumOfVertices
    K2 = NumOfVertices;
end;
if K3>NumOfVertices
    K3 = NumOfVertices;
end;

StartPoints = [];
for i=1:NumOfVertices
    TT = [i,1];
    StartPoints{i} = TT;
end; 
StartPoints = StartPoints';


Para = [];
Para(1) = NumOfVertices;
Para(2) = NumOfCommon;
Para(3) = 0.1/NumOfCommon;
Para(4) = 0.00001;
Para(5) = 0.0001;
Para(6) = 0.000000000000001;
[Maxima,Support,FValue] = SEA(M,Neighbor,StartPoints,Para');

%%Select K2 largest KKT points
[Y,I] = sort(FValue,'descend');
SelectSupport = [];
SelectMaxima  = [];
for i=1:K2
    SelectSupport{i} = Support{I(i)};
    SelectMaxima{i}  = Maxima{I(i)};
end;
SelectSupport = SelectSupport';
SelectMaxima  = SelectMaxima';

Para(1) = NumOfVertices;
DSs = RecoverDenseSubgraph(M,SelectSupport,SelectMaxima,Para);

%%Find knn of these dense subgraphs
Para = [];
Para(1) = NumOfVertices;
Para(2) = K3;
NN = KNN(M,DSs,Para);

%%Recover correspondences
CorrectCorArray1 = [];
for i=1:K2   
    I = NN(:,i);
    Cors = ConstructCorrespondenceByMapping(I,Mapping,K3,NumOfNode,NumOfNode);   
    CorrectCor = intersect(GroundCors,Cors);
    NumOfCorrectCors = size(CorrectCor,1);
    CorrectCorArray1 = [CorrectCorArray1;NumOfCorrectCors];
end;
CorrectNum = max(CorrectCorArray1);
UsedTime = toc;


