#include <mex.h>
#include <math.h>
#include <vector>
#include <map>
#include <time.h>
using namespace std;
/* 
	function [Label1,Adj1,Label2,Adj2,GroundTruth]= GenRandGraph(Para)
*/
typedef vector<double> DoubleVector;
typedef vector<DoubleVector> DoubleArray;

typedef vector<int> IntVector;
typedef vector<IntVector> IntArray;

typedef struct Parameter_TYP{
	int NumOfNode1;
	int NumOfNode2;
	double Alpha,Belta;
}Parameter;

void ReadData(const mxArray* prhs[],Parameter& Para);
void GenGraph(DoubleArray& Adj,int from, int to, int NumOfEdge);
int  RandInt(int from,int to);
double RandDouble(void);
void OutputData(mxArray* plhs[],IntVector& Label1,IntVector& Label2,DoubleArray& Adj1,DoubleArray& Adj2,IntVector& Permu);
void mexFunction(int nlhs, mxArray *plhs[],int nrhs, const mxArray *prhs[])
{
	if(nrhs!=1)
		return;

	srand(time(NULL));
	Parameter Para;
	ReadData(prhs,Para);

	DoubleArray Adj1,Adj2,NewAdj2;
	IntVector Label1,Label2,NewLabel2;
	DoubleVector Dv;
	for(int i=0;i<Para.NumOfNode1;i++)
	{
		Label1.push_back(0);
		Label2.push_back(0);
		NewLabel2.push_back(0);
		Dv.push_back(0);
	}
	for(int i=0;i<Para.NumOfNode1;i++)
	{
		Adj1.push_back(Dv);
		Adj2.push_back(Dv);
		NewAdj2.push_back(Dv);
	}

	int NumOfEdge1 = (int)(Para.NumOfNode2*(Para.NumOfNode2-1)*Para.Alpha);
	GenGraph(Adj1,0,Para.NumOfNode2-1,NumOfEdge1);
	for(int i=0;i<Para.NumOfNode2-1;i++)
		for(int j=i+1;j<Para.NumOfNode2;j++)
		{
			Adj2[i][j] = Adj1[i][j];
			Adj2[j][i] = Adj1[j][i];
		}
	int NumOfEdge2 = (int)(Para.NumOfNode1*(Para.NumOfNode1-1)*Para.Alpha)-NumOfEdge1;
	GenGraph(Adj1,Para.NumOfNode2,Para.NumOfNode1-1,NumOfEdge2);
	GenGraph(Adj2,Para.NumOfNode2,Para.NumOfNode1-1,NumOfEdge2);

	for(int i=0;i<Para.NumOfNode1;i++)
	{
		Adj1[i][i] = 0;
		Adj2[i][i] = 0;
	}

	int NumOfLabel = (int)ceil((Para.NumOfNode1*Para.Belta));
	for(int i=0;i<Para.NumOfNode2;i++)
	{
		int CurLabel = RandInt(1,NumOfLabel);
		Label1[i] = CurLabel;
		Label2[i] = CurLabel;
	}
	for(int i=Para.NumOfNode2;i<Para.NumOfNode1;i++)
	{
		int CurLabel = RandInt(1,NumOfLabel);
		Label1[i] = CurLabel;
		CurLabel = RandInt(1,NumOfLabel);
		Label2[i] = CurLabel;
	}
	
	IntVector Permu;
	for(int i=0;i<Label1.size();i++)
		Permu.push_back(i); 
	for(int i=0;i<Label1.size();i++)
	{
		int j = RandInt(0,Label1.size()-1);
		int temp = Permu[i];
		Permu[i] = Permu[j];
		Permu[j] = temp;
	}
	

	IntVector RevPermu;
	for(int i=0;i<Label1.size();i++)
	{
		int j;
		for(j=0;j<Label1.size();j++)
		{
			if(Permu[j]==i)
				break;
		}

		RevPermu.push_back(j);
	}

	
	for(int i=0;i<Label1.size();i++)
		NewLabel2[i] = Label2[Permu[i]];
	for(int i=0;i<Label1.size();i++)
		for(int j=0;j<Label1.size();j++)
			NewAdj2[i][j] = Adj2[Permu[i]][Permu[j]];

	
	

	nlhs = 5;
	OutputData(plhs,Label1,NewLabel2,Adj1,NewAdj2,RevPermu);
}

void ReadData(const mxArray* prhs[],Parameter& Para)
{
	double* pData = mxGetPr(prhs[0]);

	Para.NumOfNode1 = (int)pData[0];
	Para.NumOfNode2 = (int)pData[1];
	Para.Alpha      = pData[2];
	Para.Belta      = pData[3];
}

void GenGraph(DoubleArray& Adj,int from, int to, int NumOfEdge)
{
	//to ensure connectivity
	if(from==0)
		from = 1;
	for(int i=from;i<=to;i++)
	{		
		int PreIndex = RandInt(0,i-1);
		Adj[i][PreIndex] = 1;
		Adj[PreIndex][i] = 1;
	}

	int Num = to-from+1;
	while(Num<=NumOfEdge)
	{
		int Index1 = RandInt(from,to);
		int Index2 = RandInt(0,to);
		Adj[Index1][Index2] = 1;
		Adj[Index2][Index1] = 1;
		Num++;
	}
}

int  RandInt(int from,int to)
{
	double f = RandDouble();
	double t = from+(to-from)*f;
	t        = floor(t);
	return (int)t;
}

double RandDouble(void)
{
	double f = 1.0*rand()/RAND_MAX;
	return f;
}

void OutputData(mxArray* plhs[],IntVector& Label1,IntVector& Label2,DoubleArray& Adj1,DoubleArray& Adj2,IntVector& Permu)
{
	int NumOfNode = Label1.size();
	plhs[0] = mxCreateDoubleMatrix(NumOfNode,1,mxREAL);
	double* pData = mxGetPr(plhs[0]);
	for(int i=0;i<NumOfNode;i++)
		pData[i] = Label1[i];
	plhs[1] = mxCreateDoubleMatrix(NumOfNode,NumOfNode,mxREAL);
	pData   = mxGetPr(plhs[1]);
	for(int i=0;i<NumOfNode;i++)
		for(int j=0;j<NumOfNode;j++)
			pData[i*NumOfNode+j] = Adj1[i][j];
	plhs[2] = mxCreateDoubleMatrix(NumOfNode,1,mxREAL);
	pData   = mxGetPr(plhs[2]);
	for(int i=0;i<NumOfNode;i++)
		pData[i] = Label2[i];
	plhs[3] = mxCreateDoubleMatrix(NumOfNode,NumOfNode,mxREAL);
	pData   = mxGetPr(plhs[3]);
	for(int i=0;i<NumOfNode;i++)
		for(int j=0;j<NumOfNode;j++)
			pData[i*NumOfNode+j] = Adj2[i][j];

	plhs[4] = mxCreateDoubleMatrix(NumOfNode,1,mxREAL);
	pData   = mxGetPr(plhs[4]);
	for(int i=0;i<NumOfNode;i++)
		pData[i] = Permu[i]+1;
}