#include <mex.h>
#include <math.h>
#include <vector>
#include <map>
using namespace std;
/* 
	function [AMElems,Mapping,Neighbor]= GenAffMatrix(Label1,Adj1,Label2,Adj2,Para)
*/
typedef vector<double> DoubleVector;
typedef vector<DoubleVector> DoubleArray;

typedef vector<int> IntVector;
typedef vector<IntVector> IntArray;

typedef struct IntIntDouble_TYP{
	int I[2];
	double D;
}IntIntDouble;
typedef vector<IntIntDouble> IIDVector;

typedef struct Parameter_TYP{
	double Alpha;
}Parameter;

void ReadData(const mxArray* prhs[],IntVector& Label1,DoubleArray& Adj1,IntVector& Label2,DoubleArray& Adj2,Parameter& Para);
void OutputData(mxArray* plhs[],IIDVector& AMElems,IntVector& NodeIndex1,IntVector& NodeIndex2,IntArray& Neighbors);
void mexFunction(int nlhs, mxArray *plhs[],int nrhs, const mxArray *prhs[])
{
	if(nrhs!=5)
		return;

	IntVector Label1,Label2;
	DoubleArray Adj1,Adj2;
	Parameter Para;
	ReadData(prhs,Label1,Adj1,Label2,Adj2,Para);

	IntVector NodeIndex1,NodeIndex2;
	for(int i=0;i<Label1.size();i++)
		for(int j=0;j<Label2.size();j++)
		{				
			if(Label1[i]==Label2[j])
			{
				NodeIndex1.push_back(i);
				NodeIndex2.push_back(j);

			}
		}

	int NumOfCor = NodeIndex1.size();
	IntArray Neighbors;
	IntVector Iv;
	for(int i=0;i<NumOfCor;i++)
		Neighbors.push_back(Iv);

	IIDVector AMElems;
	for(int i=0;i<NumOfCor-1;i++)
	{
		int U[2],V[2];
		U[0] = NodeIndex1[i];
		V[0] = NodeIndex2[i];
		for(int j=i+1;j<NumOfCor;j++)
		{	
			
			U[1] = NodeIndex1[j];			
			V[1] = NodeIndex2[j];

			if((U[0]==U[1])||(V[0]==V[1]))			
				continue;			

			double Diff = abs(Adj1[U[0]][U[1]]-Adj2[V[0]][V[1]]);

			if(Diff<0.1)
			{
				IntIntDouble Iid;
				Iid.I[0] = i;
				Iid.I[1] = j;
				Iid.D    = 1;
				AMElems.push_back(Iid);

				if(Adj1[U[0]][U[1]]>0.1)
				{
					Neighbors[i].push_back(j);
					Neighbors[j].push_back(i);
				}
			}
		}
	}	

	OutputData(plhs,AMElems,NodeIndex1,NodeIndex2,Neighbors);	
}

void ReadData(const mxArray* prhs[],IntVector& Label1,DoubleArray& Adj1,IntVector& Label2,DoubleArray& Adj2,Parameter& Para)
{
	int NumOfNode = mxGetM(prhs[0]);
	DoubleVector Dv;
	for(int i=0;i<NumOfNode;i++)
	{
		Label1.push_back(0);
		Label2.push_back(0);
		Dv.push_back(0);
	}

	for(int i=0;i<NumOfNode;i++)
	{
		Adj1.push_back(Dv);
		Adj2.push_back(Dv);
	}

	double* pData = mxGetPr(prhs[0]);
	for(int i=0;i<NumOfNode;i++)
		Label1[i] = (int)pData[i];
	pData         = mxGetPr(prhs[2]);
	for(int i=0;i<NumOfNode;i++)
		Label2[i] = (int)pData[i];
	pData         = mxGetPr(prhs[1]);
	for(int i=0;i<NumOfNode;i++)
		for(int j=0;j<NumOfNode;j++)
			Adj1[i][j] = pData[i*NumOfNode+j];

	pData         = mxGetPr(prhs[3]);
	for(int i=0;i<NumOfNode;i++)
		for(int j=0;j<NumOfNode;j++)
			Adj2[i][j] = pData[i*NumOfNode+j];

	Para.Alpha = mxGetScalar(prhs[4]);
}

void OutputData(mxArray* plhs[],IIDVector& AMElems,IntVector& NodeIndex1,IntVector& NodeIndex2,IntArray& Neighbors)
{
	int NumOfElems = AMElems.size();
	plhs[0] = mxCreateDoubleMatrix(NumOfElems,3,mxREAL);
	double* pData = mxGetPr(plhs[0]);
	for(int i=0;i<NumOfElems;i++)
	{
		pData[i] = AMElems[i].I[0]+1;
		pData[NumOfElems+i] = AMElems[i].I[1]+1;
		pData[2*NumOfElems+i] = AMElems[i].D;
	}
	

	int NumOfCor = NodeIndex1.size();
	plhs[1] = mxCreateDoubleMatrix(NumOfCor,2,mxREAL);
	pData   = mxGetPr(plhs[1]);
	for(int i=0;i<NumOfCor;i++)
	{
		pData[i] = NodeIndex1[i]+1;
		pData[NumOfCor+i] = NodeIndex2[i]+1;
	}

	plhs[2] = mxCreateCellMatrix(NumOfCor,1);
	for(int i=0;i<NumOfCor;i++)
	{
		int NumOfNei = Neighbors[i].size();
		mxArray* pCell = mxCreateDoubleMatrix(NumOfNei,1,mxREAL);
		pData   = mxGetPr(pCell);
		for(int j=0;j<NumOfNei;j++)
			pData[j] = Neighbors[i][j]+1;
		mxSetCell(plhs[2],i,pCell);
	}
}