#include <mex.h>
#include <vector>
using namespace std;

typedef vector<int> IntVector;
typedef vector<IntVector> IntArray;
typedef struct MapItem_TYP{
	int I[2];
}MapItem;
typedef vector<MapItem> MapVector;
typedef vector<MapVector> MapArray;

/*
CommonMap = DurPas(Label1,Adj1,Label2,Adj2,Para)
*/

class CDurPas
{
public:
	//input
	int NumOfVertices1,NumOfVertices2;
	IntVector Label1,Label2;
	IntArray  Adj1,Adj2,Neighbor1,Neighbor2;
	int MinNum;

	//state
	IntVector LevelIndex;	
	int CurrentLevel;
	IntVector StartIndex;
	int ActualNum;
	IntVector NodeIndex;

	//output	
	MapArray CommonSubgraphs;
	bool ReadData(int nrhs,const mxArray *prhs[]);
	void BuildNeighbor(void);
	void Init(void);
	void Process(void);
	MapVector CurrentComSubgraph(void);
	void Back(void);
	bool IsLegal(int Index);
	bool CheckConnected(void);
	void OutputMapping(int& nlhs,mxArray* plhs[]);
};
void CDurPas::Init(void)
{
	for(int i=0;i<NumOfVertices1;i++)
	{
		LevelIndex.push_back(-2);
		StartIndex.push_back(0);
	}
	CurrentLevel = 0;
	ActualNum    = 0;

	for(int i=0;i<NumOfVertices2;i++)
		NodeIndex.push_back(0);	
}

bool CDurPas::ReadData(int nrhs,const mxArray *prhs[])
{
	if(nrhs!=5)
		return false;
	NumOfVertices1 = mxGetM(prhs[0]);
	double* pData  = mxGetPr(prhs[0]);
	for(int i=0;i<NumOfVertices1;i++)
		Label1.push_back((int)pData[i]);
	NumOfVertices2 = mxGetM(prhs[2]);
	pData          = mxGetPr(prhs[2]);
	for(int i=0;i<NumOfVertices2;i++)
		Label2.push_back((int)pData[i]);

	IntVector Iv;
	for(int i=0;i<NumOfVertices1;i++)
		Iv.push_back(0);
	for(int i=0;i<NumOfVertices1;i++)
		Adj1.push_back(Iv);
	Iv.clear();
	for(int i=0;i<NumOfVertices2;i++)
		Iv.push_back(0);
	for(int i=0;i<NumOfVertices2;i++)
		Adj2.push_back(Iv);

	pData = mxGetPr(prhs[1]);
	for(int i=0;i<NumOfVertices1;i++)
		for(int j=0;j<NumOfVertices1;j++)
			Adj1[j][i] = (int)pData[i*NumOfVertices1+j];

	pData = mxGetPr(prhs[3]);
	for(int i=0;i<NumOfVertices2;i++)
		for(int j=0;j<NumOfVertices2;j++)
			Adj2[j][i] = (int)pData[i*NumOfVertices2+j];

	pData = mxGetPr(prhs[4]);
	MinNum = (int)pData[0];
	return true;
}

void CDurPas::BuildNeighbor(void)
{
	IntVector Iv;
	for(int i=0;i<NumOfVertices1;i++)
		Neighbor1.push_back(Iv);

	for(int i=0;i<NumOfVertices2;i++)
		Neighbor2.push_back(Iv);

	for(int i=0;i<NumOfVertices1-1;i++)
		for(int j=i+1;j<NumOfVertices1;j++)
		{
			if(Adj1[i][j]==1)
			{
				Neighbor1[i].push_back(j);
				Neighbor1[j].push_back(i);
			}
		}

	for(int i=0;i<NumOfVertices2-1;i++)
		for(int j=i+1;j<NumOfVertices2;j++)
		{
			if(Adj2[i][j]==1)
			{
				Neighbor2[i].push_back(j);
				Neighbor2[j].push_back(i);
			}
		}
}

bool CDurPas::CheckConnected(void)
{	
	if(CurrentLevel==0)
		return true;
	bool IsConnected = false;
	for(int i=0;i<CurrentLevel;i++)
	{
		if(LevelIndex[i]<0)
			continue;
		if(Adj1[i][CurrentLevel]==1)
		{
			IsConnected = true;
			break;
		}
	}
	return IsConnected;
}

void CDurPas::Process(void)
{
	while(true)
	{		
		if(CurrentLevel<0)
			break;
		else if(CurrentLevel==NumOfVertices1)
		{
			if(ActualNum>=MinNum)
			{
				MapVector CurMap = CurrentComSubgraph();
				CommonSubgraphs.push_back(CurMap);
			}			
			Back();
		}
		else
		{			
			if(ActualNum+NumOfVertices1-CurrentLevel<MinNum)
			{
				Back();
				continue;
			}	

			int NextIndex = -1;
			for(int i=StartIndex[CurrentLevel];i<NumOfVertices2;i++)
			{
				if(NodeIndex[i]==1)
					continue;
				if(Label1[CurrentLevel]==Label2[i])
				{
					NextIndex = i;
					break;
				}				
			}

			if(NextIndex>=0)
			{
				//check whether the graph is connected
				bool IsConnected = CheckConnected();
				if(!IsConnected)
				{
					StartIndex[CurrentLevel] = NumOfVertices2;
					LevelIndex[CurrentLevel] = -1;
					CurrentLevel++;
				}
				else
				{					
					StartIndex[CurrentLevel] = NextIndex+1;				
					bool Is = IsLegal(NextIndex);				
					if(!Is)
						continue;					
					LevelIndex[CurrentLevel] = NextIndex;				
					NodeIndex[NextIndex] = 1;
					CurrentLevel++;
					ActualNum++;
				}				
			}
			else
			{
				if(LevelIndex[CurrentLevel]==-1)
					Back();
				else
				{
					LevelIndex[CurrentLevel] = -1;
					CurrentLevel++;
				}
			}
		}
	}
}

MapVector CDurPas::CurrentComSubgraph(void)
{
	MapVector CurMap;
	for(int i=0;i<CurrentLevel;i++)
	{
		if(LevelIndex[i]==-1)
			continue;
		MapItem Mi;
		Mi.I[0] = i;
		Mi.I[1] = LevelIndex[i];
		CurMap.push_back(Mi);
	}
	return CurMap;
}

void CDurPas::Back(void)
{	
	if(CurrentLevel<NumOfVertices1)
	{
		StartIndex[CurrentLevel] = 0;
		LevelIndex[CurrentLevel] =-2;
	}
	CurrentLevel--;	
	if(CurrentLevel<0)
		return;
	if(LevelIndex[CurrentLevel]>=0)
	{
		NodeIndex[LevelIndex[CurrentLevel]] = 0;
		ActualNum--;
	}
}

void CDurPas::OutputMapping(int& nlhs,mxArray* plhs[])
{
	int NumOfMap = CommonSubgraphs.size();
	plhs[0] = mxCreateCellMatrix(NumOfMap,1);
	for(int i=0;i<NumOfMap;i++)
	{
		int NumOfItem = CommonSubgraphs[i].size();
		mxArray* pCell = mxCreateDoubleMatrix(NumOfItem,2,mxREAL);
		double* pData  = mxGetPr(pCell);
		for(int j=0;j<NumOfItem;j++)
		{
			pData[j] = CommonSubgraphs[i][j].I[0]+1;
			pData[j+NumOfItem] = CommonSubgraphs[i][j].I[1]+1;
		}
		mxSetCell(plhs[0],i,pCell);
	}	
}

bool CDurPas::IsLegal(int Index)
{
	bool Is = true;
	for(int i=0;i<CurrentLevel;i++)
	{
		if(LevelIndex[i]==-1)
			continue;
		if(Adj1[CurrentLevel][i]!=Adj2[Index][LevelIndex[i]])
		{
			Is = false;
			break;
		}
	}
	return Is;
}


void mexFunction(int nlhs, mxArray *plhs[],int nrhs, const mxArray *prhs[])
{
	CDurPas Cdp;
	Cdp.ReadData(nrhs,prhs);
	Cdp.BuildNeighbor();
	Cdp.Init();
	Cdp.Process();
	Cdp.OutputMapping(nlhs,plhs);
}

