#include <mex.h>
#include <math.h>
#include <vector>
#include <map>
using namespace std;
/* 
	function AMElems = ScaleAffinityMatrixSparse(P1,P2,Para)		
*/
typedef struct Vec2D_TYP{
	double x,y;
}Vec2D;
typedef vector<Vec2D> Vec2DVector;
typedef vector<double> DoubleVector;
typedef vector<DoubleVector> DoubleArray;

typedef struct AMElem_TYP{
	int I[2];
	double D;
}AMElem;
typedef vector<AMElem> AMArray;

double Dist(Vec2D P1,Vec2D P2);
void mexFunction(int nlhs, mxArray *plhs[],int nrhs, const mxArray *prhs[])
{
	if(nrhs!=3)
		return;

	//Input
	Vec2DVector P1,P2;	
	int NumOfPoint1 = mxGetM(prhs[0]);	
	double* pPoints = mxGetPr(prhs[0]);
	for(int i=0;i<NumOfPoint1;i++)
	{
		Vec2D Point;
		Point.x = pPoints[i];
		Point.y = pPoints[NumOfPoint1+i];
		P1.push_back(Point);
	}

	int NumOfPoint2 = mxGetM(prhs[1]);
	pPoints         = mxGetPr(prhs[1]);
	for(int i=0;i<NumOfPoint2;i++)
	{
		Vec2D Point;
		Point.x = pPoints[i];
		Point.y = pPoints[NumOfPoint2+i];
		P2.push_back(Point);
	}
	double* pPara=mxGetPr(prhs[2]);
	double Sigmad = pPara[0];	
	double Scale  = pPara[1];

	//compute distance
	DoubleArray Dist1,Dist2;
	DoubleVector Dv;
	for(int i=0;i<NumOfPoint1;i++)
		Dv.push_back(0);
	for(int i=0;i<NumOfPoint1;i++)
		Dist1.push_back(Dv);
	Dv.clear();
	for(int i=0;i<NumOfPoint2;i++)
		Dv.push_back(0);
	for(int i=0;i<NumOfPoint2;i++)
		Dist2.push_back(Dv);

	for(int i=0;i<NumOfPoint1-1;i++)
		for(int j=i+1;j<NumOfPoint1;j++)
		{
			Dist1[i][j]=Dist(P1[i],P1[j]);
			Dist1[j][i]=Dist1[i][j];
		}
	for(int i=0;i<NumOfPoint2-1;i++)
		for(int j=i+1;j<NumOfPoint2;j++)
		{
			Dist2[i][j]=Dist(P2[i],P2[j]);
			Dist2[j][i]=Dist2[i][j];
		}

	int NumOfCor=NumOfPoint1*NumOfPoint2;
	AMArray Af;

	for(int i=0;i<NumOfCor-1;i++)
	{
		int Cor1[2];
		Cor1[0]=i/NumOfPoint2;
		Cor1[1]=i%NumOfPoint2;
		for(int j=i+1;j<NumOfCor;j++)
		{
			int Cor2[2];
			Cor2[0]=j/NumOfPoint2;
			Cor2[1]=j%NumOfPoint2;
			
			double DistDiff = abs(Dist1[Cor1[0]][Cor2[0]]-Scale*Dist2[Cor1[1]][Cor2[1]]);
			if(DistDiff>=3*Sigmad)
				continue;
			AMElem elem;
			elem.I[0] = i;
			elem.I[1] = j;
			elem.D    = 4.5-0.5*pow(DistDiff,2.0)/pow(Sigmad,2.0);
			Af.push_back(elem);
		}
	}

	nlhs=1;
	int NumOfElem = Af.size();
	plhs[0]=mxCreateDoubleMatrix(NumOfElem,3,mxREAL);
	double* pCor = mxGetPr(plhs[0]);
	for(int i=0;i<NumOfElem;i++)
	{
		pCor[i] = Af[i].I[0]+1;
		pCor[NumOfElem+i] = Af[i].I[1]+1;
		pCor[2*NumOfElem+i] = Af[i].D;
	}
}

double Dist(Vec2D P1,Vec2D P2)
{
	Vec2D Offset;
	Offset.x = P1.x - P2.x;
	Offset.y = P1.y - P2.y;
	return sqrt(Offset.x*Offset.x+Offset.y*Offset.y);
}

