#include <mex.h>
#include <math.h>
#include <vector>
#include <set>
using namespace std;
/* 
	function DS = RecoverDenseSubgraph(AdjMatrixElems,Support,Pc,Para)	
*/
typedef vector<int> IntVector;
typedef vector<IntVector> IntArray;
typedef set<int> IntSet;
typedef vector<double> DoubleVector;
typedef vector<DoubleVector> DoubleArray;

typedef struct IntDouble_TYP{
	int I;
	double D;
}IntDouble;
typedef vector<IntDouble> IDVector;
typedef vector<IDVector>  IDArray;

typedef struct IntIntDouble_TYP{
	int I[2];
	double D;
}IntIntDouble;
typedef vector<IntIntDouble> IIDVector;

typedef struct Parameter_TYP{	
	int NumOfVertices;
}Parameter;

void QuickSort(IDVector& data,int left,int right);
void mexFunction(int nlhs, mxArray *plhs[],int nrhs, const mxArray *prhs[])
{
	if(nrhs!=4)
		return;

	IIDVector AMElems;
	IntArray Support;
	DoubleArray Pc;
	Parameter Para;	

	//read sparse adjacency matrix elements
	int NumOfEntries = mxGetM(prhs[0]);
	double* pData = mxGetPr(prhs[0]);
	for(int i=0;i<NumOfEntries;i++)
	{
		IntIntDouble Iid;
		Iid.I[0] = (int) pData[i]-1;
		Iid.I[1] = (int) pData[NumOfEntries+i]-1;
		Iid.D    = pData[2*NumOfEntries+i];

		if(Iid.I[0]<Iid.I[1])
			AMElems.push_back(Iid);
	}

	int NumOfDs = mxGetM(prhs[1]);
	for(int i=0;i<NumOfDs;i++)
	{
		mxArray* pCell1 = mxGetCell(prhs[1],i);
		mxArray* pCell2 = mxGetCell(prhs[2],i);
		double* pData1,*pData2;
		int NumOfElem = mxGetM(pCell1);
		pData1 = mxGetPr(pCell1);
		pData2 = mxGetPr(pCell2);
		IntVector Iv;
		DoubleVector Dv;
		for(int j=0;j<NumOfElem;j++)
		{
			Iv.push_back((int)pData1[j]-1);
			Dv.push_back(pData2[j]);
		}
		Support.push_back(Iv);
		Pc.push_back(Dv);
	}

	pData = mxGetPr(prhs[3]);
	Para.NumOfVertices = (int)pData[0];

	IDArray Neighbors;
	IDVector Idv;
	for(int i=0;i<Para.NumOfVertices;i++)
		Neighbors.push_back(Idv);

	for(int i=0;i<AMElems.size();i++)
	{
		IntDouble Id;
		Id.D = AMElems[i].D;
		Id.I = AMElems[i].I[1];
		Neighbors[AMElems[i].I[0]].push_back(Id);
		Id.I = AMElems[i].I[0];
		Neighbors[AMElems[i].I[1]].push_back(Id);
	}

	IntArray DSs;
	for(int i=0;i<Support.size();i++)
	{
		IDVector TIdv;
		IntDouble Id;
		for(int j=0;j<Support[i].size();j++)
		{
			Id.I = j;
			Id.D = Pc[i][j];
			TIdv.push_back(Id);
		}

		QuickSort(TIdv,0,TIdv.size()-1);

		IntSet Vs;
		Vs.insert(Support[i][TIdv[0].I]);

		double CurSum = 0;
		for(int j=1;j<TIdv.size();j++)
		{
			double PreSum = CurSum;
			int CurIdx = Support[i][TIdv[j].I];
			for(int k=0;k<Neighbors[CurIdx].size();k++)
			{
				int NIndex = Neighbors[CurIdx][k].I;
				if(Vs.find(NIndex)==Vs.end())
					continue;
				CurSum += Neighbors[CurIdx][k].D;
			}

			if(CurSum/((j+1)*(j+1))<PreSum/(j*j))
				break;
			Vs.insert(CurIdx);
		}

		IntVector TIv;
		IntSet::iterator begin = Vs.begin();
		while(begin!=Vs.end())
		{
			TIv.push_back(*begin);
			begin++;
		}

		DSs.push_back(TIv);
	}	

	//output
	nlhs = 1;
	plhs[0]  = mxCreateCellMatrix(DSs.size(),1);
	for(int i=0;i<DSs.size();i++)
	{
		mxArray* pCell = mxCreateDoubleMatrix(DSs[i].size(),1,mxREAL);
		double* pData = mxGetPr(pCell);
		for(int j=0;j<DSs[i].size();j++)
			pData[j] = DSs[i][j] + 1;
		mxSetCell(plhs[0],i,pCell);
	}
	
}

void QuickSort(IDVector& data,int left,int right)
{
	int l_hold, r_hold, mid;
	IntDouble pivot;		
    l_hold = left;
    r_hold = right;
    mid=(left+right)/2;	
	pivot = data[left];
	
    while (left < right)
    {
	  while ((data[right].D<pivot.D) && (left < right))
			right--;
      if (left != right)
      {
		  data[left] = data[right];		
          left++;
      }
	  while ((data[left].D>= pivot.D) && (left < right))
          left++;
      if (left != right)
      {
		  data[right] = data[left];		 
          right--;
      }
    }

	data[left] = pivot;	
    
	mid=left;
    left = l_hold;
    right = r_hold;
    if (left < mid)
		QuickSort(data, left, mid-1);
    if (right > mid)
		QuickSort(data, mid+1, right);
}