#include <mex.h>
#include <math.h>
#include <vector>
#include <map>
using namespace std;
/* 
	function AffinityMatrix= Am(P1,P2,Para)		
*/
typedef struct Vec2D_TYP{
	double x,y;
}Vec2D;
typedef vector<Vec2D> Vec2DVector;
typedef vector<double> DoubleVector;
typedef vector<DoubleVector> DoubleArray;

double Dist(Vec2D P1,Vec2D P2);
void mexFunction(int nlhs, mxArray *plhs[],int nrhs, const mxArray *prhs[])
{
	if(nrhs!=3)
		return;

	//Input
	Vec2DVector P1,P2;	
	int NumOfPoint1 = mxGetM(prhs[0]);	
	double* pPoints = mxGetPr(prhs[0]);
	for(int i=0;i<NumOfPoint1;i++)
	{
		Vec2D Point;
		Point.x = pPoints[i];
		Point.y = pPoints[NumOfPoint1+i];
		P1.push_back(Point);
	}

	int NumOfPoint2 = mxGetM(prhs[1]);
	pPoints         = mxGetPr(prhs[1]);
	for(int i=0;i<NumOfPoint2;i++)
	{
		Vec2D Point;
		Point.x = pPoints[i];
		Point.y = pPoints[NumOfPoint2+i];
		P2.push_back(Point);
	}
	double* pPara=mxGetPr(prhs[2]);
	double Sigmad = pPara[0];

	//compute distance
	DoubleArray Dist1,Dist2;
	DoubleVector Dv;
	for(int i=0;i<NumOfPoint1;i++)
		Dv.push_back(0);
	for(int i=0;i<NumOfPoint1;i++)
		Dist1.push_back(Dv);
	Dv.clear();
	for(int i=0;i<NumOfPoint2;i++)
		Dv.push_back(0);
	for(int i=0;i<NumOfPoint2;i++)
		Dist2.push_back(Dv);

	for(int i=0;i<NumOfPoint1-1;i++)
		for(int j=i+1;j<NumOfPoint1;j++)
		{
			Dist1[i][j]=Dist(P1[i],P1[j]);
			Dist1[j][i]=Dist1[i][j];
		}
	for(int i=0;i<NumOfPoint2-1;i++)
		for(int j=i+1;j<NumOfPoint2;j++)
		{
			Dist2[i][j]=Dist(P2[i],P2[j]);
			Dist2[j][i]=Dist2[i][j];
		}

	DoubleArray CM;
	Dv.clear();
	int NumOfCor=NumOfPoint1*NumOfPoint2;
	for(int i=0;i<NumOfCor;i++)
		Dv.push_back(0);
	for(int i=0;i<NumOfCor;i++)
		CM.push_back(Dv);

	for(int i=0;i<NumOfCor-1;i++)
	{
		int Cor1[2];
		Cor1[0]=i/NumOfPoint2;
		Cor1[1]=i%NumOfPoint2;
		for(int j=i+1;j<NumOfCor;j++)
		{
			int Cor2[2];
			Cor2[0]=j/NumOfPoint2;
			Cor2[1]=j%NumOfPoint2;
			
			double DistDiff = abs(Dist1[Cor1[0]][Cor2[0]]-Dist2[Cor1[1]][Cor2[1]]);
			if(DistDiff>=3*Sigmad)
				continue;
			CM[i][j] = 4.5-0.5*pow(DistDiff,2.0)/pow(Sigmad,2.0);			
			CM[j][i]=CM[i][j];
		}
	}

	nlhs=1;
	plhs[0]=mxCreateDoubleMatrix(NumOfCor,NumOfCor,mxREAL);
	double* pCor = mxGetPr(plhs[0]);
	for(int i=0;i<NumOfCor;i++)
		for(int j=0;j<NumOfCor;j++)
		{
			pCor[j*NumOfCor+i]=CM[i][j];
		}
}

double Dist(Vec2D P1,Vec2D P2)
{
	Vec2D Offset;
	Offset.x = P1.x - P2.x;
	Offset.y = P1.y - P2.y;
	return sqrt(Offset.x*Offset.x+Offset.y*Offset.y);
}

