/*---------------------------------------------------------------------------
File:         			ThreadDialog.java
Package:                        JFLAP Version 1.0
Author:				Magda & Octavian Procopiuc V1.0 07/15/96
                                
Description of Contents:	Contains class ThreadDialog.
				
--------------------------------------------------------------------------*/

/* 
 * Susan H. Rodger, Magda Procopiuc, Octavian Procopiuc, Eric Gramond
 * Computer Science Department
 * Duke University
 * June 1997
 * Supported by National Science Foundation DUE-9596002 and DUE-9555084.
 *
 * Copyright (c) 1997
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the author.  The name of the author may not be used to
 * endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

package flap;

import java.awt.*;
import java.util.StringTokenizer;
import java.awt.event.*;

/**
 * All the dialogs used in this package extend this dialog,
 * which is used as a workaround for the bug in JDK 1.0.2
 * (the show method is not blocking). Should be removed
 * when the bug is solved.
 *
 * @author	Magda & Octavian Procopiuc
 * @version	1.0 15 July 1996
 */
public class ThreadDialog extends Dialog implements ActionListener, WindowListener{

  static String NOT_YET = "(notyet)";
  
  String		thePushedButton = NOT_YET;
  // the thread which calls show() for this dialog.
  DialogThread		dialogThread = null;

/**
 * Creates a modal dialog to be shown from within a new thread.
 */ 
  public ThreadDialog(Frame parent, String title) {
    this(parent, title, true);
  }
/**
 * Creates a dialog to be shown from within a new thread.
 * If parameter modal is true, the dialog will be modal.
 */   
  public ThreadDialog(Frame parent, String title, boolean modal) {
    super(parent, title, modal);
    this.addWindowListener(this);
  }

/**
 * @return 	the button pushed by user.
 */
  public String getPushedButton() {
    return thePushedButton;
  }

/**
 * Sets the thread from which this dialog's show() is called.
 */
  public void setDialogThread(Thread dt) {
    thePushedButton = NOT_YET;
    dialogThread = (DialogThread) dt;
  }

  public void actionPerformed (ActionEvent e) {
    if (e.getSource() instanceof Button) {
      thePushedButton = ((Button) e.getSource()).getLabel();
      setVisible(false);
      if (dialogThread != null)
        dialogThread.resume(); 
    }
    //  return super.action(e, arg);
  }	// end of method action.
  
  public void windowClosing(WindowEvent e) 
  {
    setVisible(false);
    if (dialogThread!= null)
      dialogThread.resume();
  }
  public void windowOpened(WindowEvent e) 
  {}
  public void windowIconified(WindowEvent e) 
  {}
  public void windowDeiconified(WindowEvent e) 
  {}
  public void windowClosed(WindowEvent e)
  {}
  public void windowActivated(WindowEvent e) 
  {}
  public void windowDeactivated(WindowEvent e) 
  {}

}	// end of class TextInDialog.















