/*---------------------------------------------------------------------------
File:         			TextInDialog.java
Package:                        JFLAP Version 1.0
Author:				Magda & Octavian Procopiuc V1.0 07/15/96
                                
Description of Contents:	Contains class TextInDialog.
				
--------------------------------------------------------------------------*/

/* 
 * Susan H. Rodger, Magda Procopiuc, Octavian Procopiuc, Eric Gramond
 * Computer Science Department
 * Duke University
 * June 1997
 * Supported by National Science Foundation DUE-9596002 and DUE-9555084.
 *
 * Copyright (c) 1997
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the author.  The name of the author may not be used to
 * endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

package flap;

import java.awt.*;
import java.util.StringTokenizer;

/**
 * This is a modal Dialog in which some centered text is displayed
 * and a number of buttons are placed at the bottom. When one of these
 * buttons is pressed, the dialog is hidden and the label of the pressed
 * button can be obtained by calling getPushedButton.
 *
 * @author	Magda & Octavian Procopiuc
 * @version	1.0 15 July 1996
 */
public class TextInDialog extends ThreadDialog{

/**
 * Text to be displayed in the dialog window.
 */ 
  protected String	message;
/**
 * Width of dialog window
 */
  protected int		width = Params._dg_width;
/**
 * Height of dialog window
 */
  protected int		height = Params._dg_height;
// this contains the text split in a line by line manner.  
  private String[]	splitMessage;
/**
 * Labels of the buttons in the dialog window.
 */  
  protected String[]	buttons;

/**
 * Creates a modal dialog containing a text message and some buttons.
 */
  public TextInDialog(String message, String[] buttons, Frame parent, String title) {
    this(message, buttons, parent, title, true);
  }
/**
 * Creates a dialog containing a text message and some buttons.
 * If parameter modal is true, the dialog is modal. 
 */  
  public TextInDialog(String message, String[] buttons, Frame parent, String title, boolean modal) {
    super(parent, title, modal);
    this.message = message;
    this.buttons = buttons;
    setFont(Params._dg_font);
    setBackground(Params._dg_backcolor);
    setLayout(new BorderLayout());
    Panel p = new Panel();
    if (buttons != null) {
      Button b = null;
      for (int i=0; i < buttons.length; i++) {
        b = new Button(buttons[i]);
	b.addActionListener(this);
        b.setBackground(Params._bt_backcolor);
        p.add(b);
      }
    }
    add("South", p);
    setSize(width, height);
  }

/**
 * Paints the message line by line.
 */ 
  public void paint(Graphics g) {
    String str;
    Dimension d = getSize();
    g.setColor(Params._dg_backcolor);
    g.fillRect(0, 0, d.width - 1, d.height - 1);
    g.setColor(Params._dg_forecolor);
    int	i = 0;
    StringTokenizer st = new StringTokenizer(message, "\n", false);
    int count = st.countTokens();
    FontMetrics fm = g.getFontMetrics();
    while (st.hasMoreTokens()) {
      str = st.nextToken();
      g.drawString(str, d.width/2 - fm.stringWidth(str)/2, d.height/2 - 
		fm.getHeight()/2 - fm.getHeight() * (count/2 - i++));
    }
  }

}	// end of class TextInDialog.

