/*---------------------------------------------------------------------------
File:         			StringSorter.java
Package:                        JFLAP Version 2.0
Author:				Robyn Geer & Alex Karweit V1.0 06/03/97
                                
Description of Contents:	Contains class StringSorter.
				
--------------------------------------------------------------------------*/

/* 
 * Susan H. Rodger, Robyn Geer, Alex Karweit, Eric Gramond
 * Computer Science Department
 * Duke University
 * June 1997
 * Supported by National Science Foundation DUE-9596002 and DUE-9555084.
 *
 * Copyright (c) 1997
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the author.  The name of the author may not be used to
 * endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

package flap;

/**
  * StringSorter - a binary predicate that is used by the Sorting class
  */

public class StringSorter implements BinaryPredicate
{

  public StringSorter()
    {
    }

  /**
    * used when comparing two strings
    * @return true if string a is < b, false if a > b
    */
  public boolean execute(Object a, Object b)
    {
      String aString = (String) a;
      String bString = (String) b;
      
      return (aString.compareTo(bString) < 0);
    }
}

