/*---------------------------------------------------------------------------
File:         			PrintDialog.java
Package:                        JFLAP Version 2.0
Author:				Magda & Octavian Procopiuc V1.0 07/15/96
                                Eric Gramond V2.0 07/22/97 
 
Description of Contents:	Contains classes PrintDialog and HLine.
				
--------------------------------------------------------------------------*/

/* 
 * Susan H. Rodger, Magda Procopiuc, Octavian Procopiuc, Eric Gramond
 * Computer Science Department
 * Duke University
 * June 1997
 * Supported by National Science Foundation DUE-9596002 and DUE-9555084.
 *
 * Copyright (c) 1997
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the author.  The name of the author may not be used to
 * endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

package flap;

import java.awt.*;
import java.io.*;
import java.awt.event.*;
/**
 * This is the dialog that appears when the user chooses
 * Print from the File menu. The actual printing is done
 * in the Environment class, by calling System.exec().
 *
 * @author	Magda & Octavian Procopiuc
 * @version	1.0 15 July 1996
 */
public class PrintDialog extends ThreadDialog implements ActionListener, ItemListener{

  public static int	TABULAR = 0;
  public static int	GRAPHICPS = 1;
  public static int	PRINTER = 0;
  public static int	FILE = 1;
  public static String	DEFAULT_COMMAND;

  static {
    if (MainMenu.osName.equals(Params._sys_win95))
      DEFAULT_COMMAND = "print /D:PRN";
    else if (MainMenu.osName.equals(Params._sys_macos))
      DEFAULT_COMMAND = "";
    else	// unix-based, probably solaris.
      DEFAULT_COMMAND = "/usr/ucb/lpr";
  }

  private TextField	fileNameField, commandField;
  private String	parentName;	// for xwd.
  private Panel		commandPanel, fileNamePanel;
  public int		printFormat;
  public int		destination;
  
  /**
   * Creates a PrintDialog.
   */
  public PrintDialog(Frame f) {
    super(f, "Print", true);
    parentName = f.getTitle();
    setLayout(new BorderLayout());
    setBackground(Params._dg_backcolor);
    Button b;
    Panel p, pp;
    Checkbox c;
    HLine h;
    
    /* Print and Cancel buttons at the bottom. */
    p = new Panel();
    b = new Button("Print");
    b.setBackground(Params._bt_backcolor);
    b.addActionListener(this);
    p.add(b);
    b = new Button("Cancel");
    b.setBackground(Params._bt_backcolor);
    b.addActionListener(this);
    p.add(b); 
    add("South", p);

    /* the center panel */
    p = new Panel();
    p.setLayout(new GridLayout(3, 1));
    p.setFont(Params._dg_font);
    add("Center", p);

    FlowLayout layout = new FlowLayout(FlowLayout.LEFT, 5, 0);

    pp = new Panel();
    pp.setLayout(layout);
    pp.add(new Label("Print to: "));
    CheckboxGroup	printToGroup = new CheckboxGroup();
    pp.add(c = new Checkbox(" Printer", printToGroup, true));
    c.addItemListener(this);
    destination = PRINTER;
    pp.add(c = new Checkbox(" File", printToGroup, false));
    c.addItemListener(this);
    if (MainMenu.osName.equals(Params._sys_macos))
      ((Checkbox) c).setState(true);
    p.add(pp);

    pp = new Panel();
    commandPanel = pp;
    pp.setLayout(new GridLayout(1,2));
    pp.add(new Label("Command:"));
    commandField = new TextField(DEFAULT_COMMAND, 14);
    pp.add(commandField);
    if (MainMenu.osName.equals(Params._sys_macos))
      pp.setEnabled(false);
    p.add(pp);

    pp = new Panel();
    fileNamePanel = pp;
    pp.setLayout(new GridLayout(1,2));
    pp.add(new Label("File name:"));
    fileNameField = new TextField("", 14);
    pp.add(fileNameField);
    pp.setEnabled(false);
    p.add(pp);

  }

  public void actionPerformed(ActionEvent e) {
    if (e.getSource() instanceof Button) {
      thePushedButton = ((Button) e.getSource()).getLabel();
      setVisible(false);
    }
  }

  public void itemStateChanged(ItemEvent e) {
    if (e.getSource() instanceof Checkbox) {
      Checkbox cb = (Checkbox) e.getSource();
      if (" Printer".equals(cb.getLabel())) {
        fileNamePanel.setEnabled(false);
        destination = PRINTER;
        commandPanel.setEnabled(true);
      } else if (" File".equals(cb.getLabel())) {
        fileNamePanel.setEnabled(true);
        destination = FILE;
        commandPanel.setEnabled(false);
      } else if (" Tabular".equals(cb.getLabel())) {
        printFormat = TABULAR;
      } 
    }
  }
  
  /**
   * Returns the command to execute.
   */
  public String getCommand() {
    String answer = "";
    if (printFormat == TABULAR)
      answer = commandField.getText();   
    else if (printFormat == GRAPHICPS) {
      answer = Params._e_xwdcommand + " -name '" + parentName + "' | " +
		Params._e_xprcommand;
      if (destination == FILE) {
        String filename = fileNameField.getText();
          if (!filename.startsWith(MainMenu.fileSeparator))
            filename = MainMenu.workingDirectory + filename;
        answer += " > " + filename;
      } else 
        answer += " | " + commandField.getText();
    }
    // System.out.println("command: " + answer);
    return answer;
  }

  public String getFileName() {
   return fileNameField.getText();
  }
}

/**
 * A separator horizontal line that gives the impresion of being 3D.
 *
 * @author	Magda & Octavian Procopiuc
 * @version	1.0 15 July 1996
 */
class HLine extends Canvas {

  public Dimension getMinimumSize() {
    return new Dimension(2, 2);
  }

  public void paint(Graphics g) {
    Dimension d = getSize();
    g.setColor(getBackground().brighter());
    g.drawLine(1, d.height/2, d.width - 1, d.height/2);
    g.setColor(getBackground().darker());
    g.drawLine(1, d.height/2 + 1, d.width - 1, d.height/2 + 1);
  }
}
