/*---------------------------------------------------------------------------
File:         			PopupMenu.java
Package:                        JFLAP Version 2.0
Author:				Magda & Octavian Procopiuc V1.0 07/15/96
                                Eric Gramond V2.0 07/22/97 
 
Description of Contents:	Contains class PopupMenu.
				
--------------------------------------------------------------------------*/

/* 
 * Susan H. Rodger, Magda Procopiuc, Octavian Procopiuc, Eric Gramond
 * Computer Science Department
 * Duke University
 * June 1997
 * Supported by National Science Foundation DUE-9596002 and DUE-9555084.
 *
 * Copyright (c) 1997
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the author.  The name of the author may not be used to
 * endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

package flap;

import	java.awt.*;
import  java.awt.event.*;
import	java.util.*;


/**
  * This class is an abstract PopupMenu that appears on the canvas and can be extended.
  *
  * @author	Octavian Procopiuc
  * @version	1.0 15 July 96
  */


public abstract class PopupMenu {

  Desktop	parent;
  int		offx = 9;
  int		offy = 5;
  String[]	theItems;
  boolean[]	isValid;
  int		itemsCounter;	// the # of items.
  int		height;		// the height of an item.
  int		width;		// the width of the menu.
  int		hasFocus;	// the item that has the focus.
  Point		p;		// the upper left point of the menu.
  State		s = null;
  Transition	t = null;

  
  PopupMenu(Desktop parent, String[] items) {
    this.parent = parent;
    width = Params._p_width;
    theItems = items;
    itemsCounter = theItems.length;
    isValid = new boolean[itemsCounter];
    p = new Point(0, 0);
    height = Params._p_height;
    invalidateAll();
  }

  public void setState(State s) {
    this.s = s;
  }

  public void setTransition(Transition t) {
    this.t = t;
  }

  public void invalidateAll() {
    hasFocus = -1;
    s = null;
    t = null;
    for (int i=0; i<itemsCounter; i++)
      isValid[i] = false;
  }

  public abstract boolean takeAction();

  public void move(int x, int y) {
    Dimension	d = parent.getSize();
    int xSize = x+width;
    int ySize = y + (height*itemsCounter+10);
    if(xSize > d.width)
      x -= width;
    if(ySize > d.height)
      y -= (height*itemsCounter+10);

    p.x = x;
    p.y = y;
  }

  public Point writeHere(int index) {
    int x = p.x + offx;
    int y = p.y + (index + 1) * height - offy;
    return new Point(x, y);
  }

  /**
    * Paints the popup menu.
    */
  public void paint(Graphics g) {
    Point	w;
    
    g.setFont(Params._p_font);
    g.setColor(Params._p_backcolor);
    g.fill3DRect(p.x, p.y - 5, width, height * itemsCounter + 10, true);
    if (hasFocus >= 0)
      if (isValid[hasFocus]) {
        g.setColor(Params._p_focusedcolor);
        g.fillRect(p.x + 5, p.y + 1 + hasFocus * height, width-10, height-2); 
    }
    g.setColor(Params._p_forecolor);
    for (int i=0; i<itemsCounter; i++) {
      if (isValid[i]) {
        w = writeHere(i);
        g.drawString(theItems[i], w.x, w.y);
      }
    }
    g.setColor(Params._p_invalidcolor);
    for (int i=0; i<itemsCounter; i++) {
      if (!isValid[i]) {
        w = writeHere(i);
        g.drawString(theItems[i], w.x, w.y);
      }
    }
   
  }

}
