/*---------------------------------------------------------------------------
File:         			Popup.java
Package:                        JFLAP Version 2.0
Author:				Magda & Octavian Procopiuc V1.0 07/15/96
                                Eric Gramond V2.0 07/22/97 
 
Description of Contents:	Contains class Popup.
				
--------------------------------------------------------------------------*/

/* 
 * Susan H. Rodger, Magda Procopiuc, Octavian Procopiuc, Eric Gramond
 * Computer Science Department
 * Duke University
 * June 1997
 * Supported by National Science Foundation DUE-9596002 and DUE-9555084.
 *
 * Copyright (c) 1997
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the author.  The name of the author may not be used to
 * endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

package flap;

import	java.awt.*;
import  java.awt.event.*;
import	java.util.*;


/**
 * This class implements the popup menu that appears on the canvas
 * when the right mouse is kept down. It doesn't have a graphic context,
 * so the actual painting of the menu is done in the Desktop class.
 * Maybe make it extend Window and be independent...
 *
 * @author	Octavian Procopiuc
 * @version	1.0 15 July 96
 */
public class Popup extends PopupMenu {
  final static int MAKE_FINAL		= 0;
  final static int MAKE_NONFINAL	= 1;
  final static int MAKE_INITIAL		= 2;
  final static int REMOVE_STATE		= 3;
  final static int REMOVE_TRANSITION	= 4;

  final static String[]	Items = {"Make This State Final", "Make This State Non-Final", "Make This State Initial", "Remove This State", "Remove This Transition"};

  Popup(Desktop parent) {
    super(parent, Items);
  }

  public void setState(State s) {
    this.s = s;
    if (s.isFinal)
      isValid[MAKE_NONFINAL] = true;
    else
      isValid[MAKE_FINAL] = true;
    if (s != parent.initialState)
      isValid[MAKE_INITIAL] = true;
    isValid[REMOVE_STATE] = true;
  }

  public void setTransition(Transition t) {
    this.t = t;
    isValid[REMOVE_TRANSITION] = true;
  }

  public boolean takeAction() {
    boolean answer = false;	// is made true if any action was taken.
    Transition tt;
    switch (hasFocus) {
      case MAKE_FINAL:
        if (isValid[MAKE_FINAL] && s != null) {
          s.isFinal = true;
          answer = true;
        }
        break;
      case MAKE_NONFINAL:
        if (isValid[MAKE_NONFINAL] && s != null) {
          s.isFinal = false;
          answer = true;
        }
        break;
      case MAKE_INITIAL:
        if (isValid[MAKE_INITIAL] && s != null) {
          parent.initialState = s;
          answer = true;
        }
        break;
      case REMOVE_STATE:
        if (isValid[REMOVE_STATE] && s != null) 
	  parent.removeState(s);
        break;
      case REMOVE_TRANSITION:
        if (isValid[REMOVE_TRANSITION] && t != null) {
          parent.removeTransition(t);
          answer = true;
        }
        break;
      default:
        break;
    }	// end of switch hasFocus.
    return answer;
  }
     
}	// end of class Popup.
