/*---------------------------------------------------------------------------
File:         			Params.java
Package:                        JFLAP Version 2.0
Author:				Magda & Octavian Procopiuc V1.0 07/15/96
                                Eric Gramond V2.0 07/22/97 
 
Description of Contents:	Contains class Params.
				
--------------------------------------------------------------------------*/

/* 
 * Susan H. Rodger, Magda Procopiuc, Octavian Procopiuc, Eric Gramond
 * Computer Science Department
 * Duke University
 * June 1997
 * Supported by National Science Foundation DUE-9596002 and DUE-9555084.
 *
 * Copyright (c) 1997
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the author.  The name of the author may not be used to
 * endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

package flap;

import java.awt.*;
import java.awt.image.*;
import java.util.Properties;

/**
 * This class is a wrapper for the parameters used
 * in the flap package.
 *
 * @author	Magda & Octavian Procopiuc
 * @version	1.0 15 July 1996
 */
public class Params {


  public static int emptyDfaLabelWidth = 3;


  private static Color	cafeAuLait0	= new Color(0xd8d2c0);
  private static Color	cafeAuLait1	= new Color(0xe5e0ce);
  private static Color	cafeAuLait2	= new Color(0xeae4d2);
  private static Color	tomato1		= new Color(0xff6347);
  private static Color	yellow2		= new Color(0xeeee00);
  private static Color	gray63		= new Color(0xa1a1a1);

/*
 * Environment parameters:
 */
  public static int	_e_width = 710;
  public static int	_e_height = 530;
  public static int	_e_inputfieldlength = 30;  // doesn't apply to TM2.
  public static Color	_e_backcolor = cafeAuLait1;  
  public static String	_e_exampleurl = "http://www.cs.duke.edu/~magda/flap/examples/example."; 
  public static String	_e_xwdcommand = "/usr/local/X/bin/xwd -nobdrs";
  public static String	_e_xprcommand = "/usr/local/X/bin/xpr -device ps";

/*
 * Desktop parameters:
 */
  public static Color	_d_backcolor = Color.white;
  public static Color	_d_fadedbackcolor = cafeAuLait1;
  public static Color	_d_forecolor = Color.black;

/* 
 * State parameters:
 */ 
  public static Color	_s_forecolor = Color.black;
  public static Color	_s_normalcolor =  yellow2;  
  public static Color	_s_focusedcolor = tomato1;   
  public static Color   _s_highlightedcolor = Color.green;
  public static int	_s_radius = 14;
  public static Font	_s_font = new Font("TimesRoman", Font.PLAIN, 11);

/*
 * Transition parameters:
 */
  public static Color	_t_interiorcolor = yellow2;
  public static Color	_t_normalcolor = Color.black;
  public static Color	_t_focusedcolor = tomato1;
  public static Color	_t_selectedcolor = tomato1;
  public static Font	_t_font =  new Font("TimesRoman", Font.PLAIN, 14);
  public static int	_t_distance = 35;
  public static int	_t_height = 18;
  public static int	_t_ltheight = 70;	// loop transition height.

/*
 * Configuration parameters:
 */
  public static int	_c_height = 85;
  public static int	_c_width = 150;
  public static Color	_c_confcolor = cafeAuLait1;
  public static Color	_c_backcolor = Color.white;
  public static Color	_c_forecolor = Color.black;
  public static Font	_c_font = new Font("System", Font.PLAIN, 12);

/*
 * Upper window parameters (this is the step run window):
 */
  public static int	_uw_height = 310;
  public static int	_uw_width = 760;
  public static Color	_uw_backcolor = cafeAuLait1;

/*
 * Trace window parameters:
 */
  public static int	_tw_width = 215;
  public static int	_tw_height = 190;
  public static int	_tw_voffset = 27;  // the vert. offset of the config. 
  public static int	_tw_hoffset = 5;  // the horiz. offset of the config. 
  public static Font	_tw_font = new Font("System", Font.PLAIN, 14);
  public static Color	_tw_backcolor = cafeAuLait1;

/*
 * Popup menu parameters (this is the menu you get with the 
 * right mouse button, or CTRL-button):
 */
  public static int	_p_width = 140;
  public static int	_p_height = 18;
  public static Color	_p_backcolor = cafeAuLait1;
  public static Color	_p_forecolor = Color.black;
  public static Color	_p_focusedcolor = tomato1;
  public static Color	_p_invalidcolor = gray63;
  public static Font	_p_font = _s_font; 

/*
 * Menu bar parameters:
 */
  public static Font	_m_font = new Font("TimesRoman", Font.BOLD, 12);

/*
 * Main menu parameters:
 */
  public static int	_mm_width = 185;
  public static int	_mm_height = 190;
  public static Color	_mm_backcolor = cafeAuLait1;

/*
 * Machine parameters:
 */ 
  public static int	_ma_capacity = 1600;
  
/*
 * Dialogs parameters:
 */
  public static Font	_dg_font = new Font("TimesRoman", Font.PLAIN, 14);
  public static Color	_dg_backcolor = cafeAuLait2; 
  public static Color	_dg_forecolor = Color.black;
  public static int	_dg_width = 270;
  public static int	_dg_height = 185;

/*
 * Help dialog parameters:
 */
  public static int	_h_rows = 18;
  public static int	_h_columns = 72;
  public static Font	_h_font = new Font("TimesRoman", Font.PLAIN, 14);
  public static Color	_h_backcolor = cafeAuLait2;

/*
 * Buttons parameters:
 */
  public static Color	_bt_backcolor = cafeAuLait0;

/*
 * Types of systems on which the application runs:
 */
  public static String	_sys_win95 = "Windows 95";
  public static String	_sys_macos = "macos";
  public static String	_sys_solaris = "solaris"; // not actually used.
  
  static Color		_flake_color = new Color(0x98f5ff);
  
  // bitmaps:
  static byte[] crossImageData = {
    0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,0,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
    0,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,2,
    1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,1,1,1,1,2,2,0,
    0,2,2,1,1,1,1,1,1,1,0,0,0,0,0,1,1,1,1,1,2,2,0,0,0,
    0,0,0,2,2,1,1,1,1,1,1,1,0,1,1,1,1,1,2,2,0,0,0,0,0,
    0,0,0,0,0,2,2,1,1,1,1,1,1,1,1,1,2,2,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,2,1,1,1,1,1,1,1,2,2,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,
    0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,
    0,0,0,0,0,1,1,1,1,1,1,2,2,2,1,1,1,1,0,0,0,0,0,0,0,
    0,0,0,0,1,1,1,1,1,1,2,2,0,0,2,1,1,1,1,0,0,0,0,0,0,
    0,0,0,1,1,1,1,1,1,2,2,0,0,0,0,2,1,1,1,0,0,0,0,0,0, 
    0,0,1,1,1,1,1,1,2,2,0,0,0,0,0,0,2,1,1,1,0,0,0,0,0,
    0,1,1,1,1,1,1,2,2,0,0,0,0,0,0,0,0,2,1,1,0,0,0,0,0,
    0,1,1,1,1,1,2,2,0,0,0,0,0,0,0,0,0,0,2,1,1,0,0,0,0,
    0,1,1,1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,2,1,1,0,0,0,
    0,2,1,1,1,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,
    0,0,2,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,1,0,0,
    0,0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,1,0,0,
    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,
  };
  static int[]	crossImageColors = {0, 0xff0000, 0xb22222};
  static int	crossImageWidth = 25;
  static int	crossImageHeight = 22;
  
  static byte[] flakeImageData = {
        0,0,0,0,0,0,1,2,2,0,1,2,2,0,1,2,2,0,0,0,0,0,0,
        0,0,0,0,0,0,1,2,2,0,1,2,2,0,1,2,2,0,0,0,0,0,0,
        0,0,0,0,0,0,1,1,1,2,2,2,2,2,2,1,1,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,0,0,0,0,0,0,0,0,
        1,2,2,0,1,2,2,0,1,1,1,2,2,1,1,0,1,2,2,0,1,2,2,
        1,2,2,0,1,2,2,0,0,0,1,2,2,0,0,0,1,2,2,0,1,2,2,
        1,1,1,2,2,1,1,0,0,0,1,2,2,0,0,0,1,1,1,2,2,1,1,
        0,0,1,2,2,0,0,0,0,0,1,2,2,0,0,0,0,0,1,2,2,0,0,
        1,2,2,1,1,2,2,0,0,0,1,2,2,0,0,0,1,2,2,1,1,2,2,
        1,2,2,0,1,2,2,0,0,0,1,2,2,0,0,0,1,2,2,0,0,2,2,
        1,1,1,0,1,1,1,2,2,2,2,2,2,2,2,2,2,1,1,0,0,1,1,
        0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,
        0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,
        0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,
        1,2,2,0,1,2,2,1,1,1,1,2,2,1,1,1,1,2,2,0,1,2,2,
        1,2,2,0,1,2,2,0,0,0,1,2,2,0,0,0,1,2,2,0,1,2,2,
        1,1,1,2,2,1,1,0,0,0,1,2,2,0,0,0,1,1,1,2,2,1,1,
        0,0,1,2,2,0,0,0,0,0,1,2,2,0,0,0,0,0,1,2,2,0,0,
        1,2,2,1,1,2,2,0,0,0,1,2,2,0,0,0,1,2,2,1,1,2,2,
        1,2,2,0,1,2,2,0,0,0,1,2,2,0,0,0,1,2,2,0,1,2,2,
        1,1,1,0,1,1,1,0,1,2,2,2,2,2,2,0,1,1,1,0,1,1,1,
        0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,1,2,2,1,1,2,2,1,1,2,2,0,0,0,0,0,0,
        0,0,0,0,0,0,1,2,2,0,1,2,2,0,1,2,2,0,0,0,0,0,0,
        0,0,0,0,0,0,1,1,1,0,1,1,1,0,1,1,1,0,0,0,0,0,0,
  };
  static int[]	flakeImageColors = {0, 0x8db6cd, _flake_color.getRGB()};
  static int	flakeImageWidth = 23;
  static int	flakeImageHeight = 25;

  static byte[] iconImageData = {
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,2,2,2,2,2,2,2,2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,2,1,2,2,2,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,2,1,2,1,2,2,2,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,1,2,2,2,1,2,1,2,2,2,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,1,2,2,2,1,2,1,2,2,2,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,1,2,2,2,1,2,2,1,2,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,1,2,2,2,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,2,2,2,2,2,2,2,2,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  };
  static int[]	iconImageColors = {0xFFFFFF, 0x0, _s_normalcolor.getRGB()};
  static int	iconImageWidth = 64;
  static int	iconImageHeight = 64;
  
/*
 * Images appearing in the program:
 */
  public static Image	_img_flake = generateImage(
  	flakeImageData, flakeImageColors, flakeImageWidth, flakeImageHeight);
  public static Image	_img_cross = generateImage(
  	crossImageData, crossImageColors, crossImageWidth, crossImageHeight);
  public static Image	_img_icon = generateImage(
  	iconImageData, iconImageColors, iconImageWidth, iconImageHeight);

/**
 * Generates an Image object from a byte array
 */ 
  public static Image generateImage(
  	byte[] imageData, int[] colors, int width, int height) {
  
    int		count = colors.length;
    byte[]	red = new byte[count];
    byte[]	green = new byte[count];
    byte[]	blue = new byte[count];  
    
    for (int i = 0; i < count; i++) {
      red[i] = (byte) (colors[i] >> 16);
      green[i] = (byte) ((colors[i] & 0x00ff00) >> 8); 
      blue[i] = (byte) (colors[i] & 0x0000ff);
    }
    IndexColorModel model = new IndexColorModel(8, count, red, green, blue, 0);
    MemoryImageSource memImage = new MemoryImageSource(width, height, model, imageData, 0, width);
    Image answer = Toolkit.getDefaultToolkit().createImage(memImage);
    return answer;
  }
 
/**
 * Loads the parameters from the given Properties object
 */  
  public static void load(Properties params) {
    Color	color;
    int		i;
    String	str;
    
    if ((color = readAColor("state.background.normal", params)) != null) 
      Params._s_normalcolor = color;
    if ((color = readAColor("state.background.focused", params)) != null) 
      Params._s_focusedcolor = color;
    if ((color = readAColor("state.foreground", params)) != null) 
      Params._s_forecolor = color;
    if ((color = readAColor("transition.background", params)) != null) 
      Params._t_interiorcolor = color;
    if ((color = readAColor("transition.foreground.normal", params)) != null) 
      Params._t_normalcolor = color;
    if ((color = readAColor("transition.foreground.selected", params)) != null) 
      Params._t_selectedcolor = color;
    if ((color = readAColor("mainwindow.background", params)) != null) 
      Params._e_backcolor = color;
    if ((color = readAColor("canvas.background.normal", params)) != null) 
      Params._d_backcolor = color;
    if ((color = readAColor("canvas.background.faded", params)) != null) 
      Params._d_fadedbackcolor = color;
    if ((color = readAColor("dialog.background", params)) != null) 
      Params._dg_backcolor = color;
    if ((color = readAColor("configuration.background", params)) != null) 
      Params._c_confcolor = color;    
    if ((color = readAColor("configuration.foreground", params)) != null) 
      Params._c_forecolor = color;
    if ((color = readAColor("steprunwindow.background", params)) != null) 
      Params._uw_backcolor = color;
    if ((color = readAColor("steprunwindow.canvas.background", params)) != null) 
      Params._c_backcolor = color;
    if ((color = readAColor("canvas.popup.background.normal", params)) != null) 
      Params._p_backcolor = color;
    if ((color = readAColor("canvas.popup.background.focused", params)) != null) 
      Params._p_focusedcolor = color;
    if ((color = readAColor("canvas.popup.foreground.normal", params)) != null) 
      Params._p_forecolor = color;
    if ((color = readAColor("canvas.popup.foreground.nonselectable", params)) != null) 
      Params._p_invalidcolor = color;
    if ((color = readAColor("button.background", params)) != null) 
      Params._bt_backcolor = color;
    if ((color = readAColor("helpdialog.background", params)) != null) 
      Params._h_backcolor = color;
    if ((color = readAColor("tracewindow.background", params)) != null) 
      Params._tw_backcolor = color;
    if ((color = readAColor("snowflake.color", params)) != null) 
      Params._flake_color = color;

    if ((i = readAnInt("mainwindow.width", params)) >= 1)
      Params._e_width = i;
    if ((i = readAnInt("mainwindow.height", params)) >= 1)
      Params._e_height = i;
    if ((i = readAnInt("state.radius", params)) >= 1)
      Params._s_radius = i;
    if ((i = readAnInt("transition.height", params)) >= 1)
      Params._t_height = i;
    if ((i = readAnInt("transition.distance", params)) >= 1)
      Params._t_distance = i;
    if ((i = readAnInt("steprunwindow.width", params)) >= 1)
      Params._uw_width = i;
    if ((i = readAnInt("steprunwindow.height", params)) >= 1)
      Params._uw_height = i;
    if ((i = readAnInt("dialog.width", params)) >= 1)
      Params._dg_width = i;
    if ((i = readAnInt("dialog.height", params)) >= 1)
      Params._dg_height = i;
    if ((i = readAnInt("mainwindow.inputfield.length", params)) >= 1)
      Params._e_inputfieldlength = i;
    if ((i = readAnInt("machine.capacity", params)) >= 1)
      Params._ma_capacity = i;
     if ((i = readAnInt("tracewindow.width", params)) >= 1)
      Params._tw_width = i;
    if ((i = readAnInt("tracewindow.height", params)) >= 1)
      Params._tw_height = i;
     if ((i = readAnInt("tracewindow.configuration.hoffset", params)) >= 1)
      Params._tw_hoffset = i;
    if ((i = readAnInt("tracewindow.configuration.voffset", params)) >= 1)
      Params._tw_voffset = i;

    if ((str = params.getProperty("print.xwd.command")) != null)
      Params._e_xwdcommand = str;
    if ((str = params.getProperty("print.xpr.command")) != null)
      Params._e_xprcommand = str;
  }
   
  private static Color readAColor(String key, Properties params) {
    Color	color = null;
    String	buf = params.getProperty(key);
    
    if (buf != null) {
      try {
        color = new Color(Integer.parseInt(buf, 16));
      } catch (Exception e) {
        color = null;
      }
    }
    return color;
  }

  private static int readAnInt(String key, Properties params) {
    int		answer = -1;
    String	buf = params.getProperty(key);
    
    if (buf != null) {
      try {
        answer = Integer.parseInt(buf);
      } catch (Exception e) {
        answer = -1;
      }
    }
    return answer;
  }
}
