/*---------------------------------------------------------------------------
File:         			PDA.java
Package:                        JFLAP Version 1.0
Author:				Magda & Octavian Procopiuc V1.0 07/15/96
                                
Description of Contents:	Contains class PDA.
				
--------------------------------------------------------------------------*/

/* 
 * Susan H. Rodger, Magda Procopiuc, Octavian Procopiuc, Eric Gramond
 * Computer Science Department
 * Duke University
 * June 1997
 * Supported by National Science Foundation DUE-9596002 and DUE-9555084.
 *
 * Copyright (c) 1997
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the author.  The name of the author may not be used to
 * endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

package flap;

import java.util.*;

/**
 * This class simulates the behavior of a 
 * pushdown automaton.
 *
 * @author	Magda & Octavian Procopiuc
 * @version	1.0 15 July 1996
 */ 
public class PDA extends Machine { 

// Acceptance types 
  final static String FINAL_STATE = "Final State";
  final static String EMPTY_STACK = "Empty Stack";
  final static String FINAL_AND_EMPTY = "Final State & Empty Stack";

  String	acceptanceType = FINAL_STATE;

/**
 * creates PDA corresponding to its desktop image.
 */
  public PDA(Desktop d) {
    super(d);
  }

/*
 * Creates a new configuration starting from configuration c, according
 * to the transition rule of a PDA
 * Overrides Machine.expand()
 */
  boolean expand(Configuration c) {
    boolean willBeValid;
    Transition t;
    Configuration cc;

    String input, pop, push;

    willBeValid = false;
    for (Enumeration et=c.theState.transitions.elements(); et.hasMoreElements(); )   {
      t = (Transition) et.nextElement();
      StringTokenizer stk = new StringTokenizer(t.label, ",;", false);
      input = stk.nextToken().trim();
      pop = stk.nextToken().trim();
      push = stk.nextToken().trim();
      if (c.theString.startsWith(input) && c.theStack.startsWith(pop)) {
        willBeValid = true;
        cc = new Configuration(t.to, c.theString.substring(input.length()), push + c.theStack.substring(pop.length()), c, this);
        if (!isAlreadyIn(temp, cc)) {
          temp.addElement(cc);
          nCurrentConfigs++;
          if (cc.isAccept()) {
            acceptInput = true;
            acceptingConfig = cc;
          }
        }
      }
    }
    return willBeValid;
  }  // end of method expand

/*
 * Creates the initial configuration.
 * Overrides Machine.initialConfig().
 */
  Configuration initialConfig() {
    return new Configuration(d.initialState, input, "Z", null, this);
  } // end of method initialConfig

/*
 * Checks if a transition introduces non-determinism.
 * @param t	Transition to be checked.
 *        v	Vector of transitions against which t is checked.
 * @return	true if t does not introduce any non-determinism. 
 * Overrides Machine.isDeterministic().
 */
  boolean isDeterministic(Transition t, Vector v) {
    Enumeration e;
    Transition vt;
    String input, pop, push;
    String vinput, vpop, vpush;

    if (v.size() == 0) 
      return true;

    StringTokenizer stk = new StringTokenizer(t.label, ",;", false);
    input = stk.nextToken().trim();
    pop = stk.nextToken().trim();
    push = stk.nextToken().trim();

    for (e = v.elements(); e.hasMoreElements(); ) {
      vt = (Transition) e.nextElement();
      stk = new StringTokenizer(vt.label, ",;", false);
      vinput = stk.nextToken().trim();
      vpop = stk.nextToken().trim();
      vpush = stk.nextToken().trim();

      if (input.equals(vinput)) { 
         if (pop.equals(vpop))
           if ((t.to != vt.to) || (!push.equals(vpush)))
             return false;
           else {}
         else if (substringRelation(pop, vpop))
              return  false;  
      } else if (substringRelation(input, vinput) && substringRelation(pop, vpop))      
             return false;    
    }
  
    return true;
  }  // end of method isDeterministic


}  // end of class PDA
