/*---------------------------------------------------------------------------
File:         			OKDialog.java
Package:                        JFLAP Version 1.0
Author:				Magda & Octavian Procopiuc V1.0 07/15/96
                                
Description of Contents:	Contains class OKDialog.
				
--------------------------------------------------------------------------*/

/* 
 * Susan H. Rodger, Magda Procopiuc, Octavian Procopiuc, Eric Gramond
 * Computer Science Department
 * Duke University
 * June 1997
 * Supported by National Science Foundation DUE-9596002 and DUE-9555084.
 *
 * Copyright (c) 1997
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the author.  The name of the author may not be used to
 * endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

package flap;

import java.awt.*;

/**
 * A TextInDialog with only an OK button.
 *
 * @see		flap.TextInDialog
 * @author	Magda & Octavian Procopiuc
 * @version	1.0 15 July 1996
 */
public class OKDialog extends TextInDialog {

  final static private String	OK_STRING = "   OK   ";
  final static private String[]	OKButtonStr = {OK_STRING};

/**
 * @param message	Text to be displayed
 *        parent	Parent frame of dialog
 *        title		Title of the dialog window
 */
  public OKDialog(String message, Frame parent, String title) {
    super(message, OKButtonStr, parent, title);
    
  }

}	// end of class OKDialog.
