/*---------------------------------------------------------------------------
File:         			MinimizeTreePopup.java
Package:                        JFLAP Version 2.0
Author:				Magda & Octavian Procopiuc V1.0 07/15/96
                                Eric Gramond V2.0 07/22/97 
 
Description of Contents:	Contains class MinimizeTreePopup.
				
--------------------------------------------------------------------------*/

/* 
 * Susan H. Rodger, Magda Procopiuc, Octavian Procopiuc, Eric Gramond
 * Computer Science Department
 * Duke University
 * June 1997
 * Supported by National Science Foundation DUE-9596002 and DUE-9555084.
 *
 * Copyright (c) 1997
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the author.  The name of the author may not be used to
 * endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

package flap;

import	java.awt.*;
import  java.awt.event.*;
import	java.util.*;


/**
 * This class implements the popup menu that appears on the canvas
 * when the right mouse is kept down. It doesn't have a graphic context,
 * so the actual painting of the menu is done in the Desktop class.
 * Maybe make it extend Window and be independent...
 * This Popup is used in the tree building section of the minimize algorithm.
 *
 * @author	Octavian Procopiuc
 * @version	1.0 15 July 96
 */
public class MinimizeTreePopup extends PopupMenu {
  final static int SPLIT		= 0;
  final static int ADD_CHILD    	= 1;
  final static int REMOVE_M_STATE       = 2;
  final static int CHECK_STATE          = 3;  
  final static int SOLVE_STATE          = 4;

  final static String[]	Items = {"Split this node", "Add a child ", "Remove this node", "Check this node", "Solve this node"};


  TreeMachine treeM;

  MinimizeTreePopup(TreeMachine parent) {
    super(parent.d, Items);
    treeM = parent;
  }

  public void setState(State s) {
    this.s = s;
    
    if (treeM.canSplitState(s))
      isValid[SPLIT] = true;
    if (treeM.canAddChild(s))
      isValid[ADD_CHILD] = true;
    if(treeM.canRemoveState(s))
       isValid[REMOVE_M_STATE] = true;
    if(((MinimizeDesktop) treeM.d).expanding == s) {
      isValid[CHECK_STATE] = true;
      isValid[SOLVE_STATE] = true;
    }
  }

  public boolean takeAction() {
    boolean answer = false;	// is made true if any action was taken.
    Transition tt;
 
   if ( hasFocus < 0 || hasFocus >= itemsCounter || s == null || !isValid[hasFocus])
      return answer;

    switch (hasFocus) {
    case SPLIT:
      treeM.splitState(s);
      answer = true;
      break;
    case ADD_CHILD:
      treeM.addChild(s);
      answer = true;
      break;
    case REMOVE_M_STATE:
      treeM.removeState(s);
      answer = true;
      break;
    case CHECK_STATE:
      treeM.checkDoneExpanding(s);
      break;
    case SOLVE_STATE:
      treeM.solveState(s);
      break;
    default:
      break;
    }	// end of switch hasFocus.
    return answer;
  }

}
