/*---------------------------------------------------------------------------
File:         			MinimizeSortPredicate.java
Package:                        JFLAP Version 2.0
Author:				Magda & Octavian Procopiuc V1.0 07/15/96
                                Eric Gramond V2.0 07/22/97 
 
Description of Contents:	Contains class MinimizeSortPredicate.
				
--------------------------------------------------------------------------*/

/* 
 * Susan H. Rodger, Magda Procopiuc, Octavian Procopiuc, Eric Gramond
 * Computer Science Department
 * Duke University
 * June 1997
 * Supported by National Science Foundation DUE-9596002 and DUE-9555084.
 *
 * Copyright (c) 1997
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the author.  The name of the author may not be used to
 * endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

package flap;

/**
 * This class is a BinaryPredicate used for sorting VectorArrays of Characters
 *
 *
 * @see		flap.Machine
 * @author	Magda & Octavian Procopiuc
 * @version	1.0, 15 July 1996
 */ 

public class MinimizeSortPredicate implements BinaryPredicate {


  public MinimizeSortPredicate()
  {}
  

  /** Used for sorting the vectors with the JGL VectorArray sorting of Characters */
  public boolean execute(Object a, Object b) {
    MinimizeTreeState a1, b1;
    a1 = (MinimizeTreeState) a;
    b1 = (MinimizeTreeState) b;
    return ((State)(a1.stateList.elementAt(0))).id <    ((State)(b1.stateList.elementAt(0))).id;
  }
}

