/*---------------------------------------------------------------------------
File:         			MainMenu.java
Package:                        JFLAP Version 2.0
Author:				Magda & Octavian Procopiuc V1.0 07/15/96
                                Eric Gramond V2.0 07/22/97 
 
Description of Contents:	Contains class MainMenu.
				
--------------------------------------------------------------------------*/

/* 
 * Susan H. Rodger, Magda Procopiuc, Octavian Procopiuc, Eric Gramond
 * Computer Science Department
 * Duke University
 * June 1997
 * Supported by National Science Foundation DUE-9596002 and DUE-9555084.
 *
 * Copyright (c) 1997
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the author.  The name of the author may not be used to
 * endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

package flap;

import java.awt.*;
import java.util.*;
import java.io.*;
import java.awt.event.*;

/**
 * The initial menu which enables the user to open
 * as many Environment windows as he/she wants
 * with the desired machine type. Basically,
 * it contains one button for each machine type
 * and an exit button.
 *
 * @see		flap.Environment
 * @author	Magda & Octavian Procopiuc
 * @version	1.0 15 July 1996
 */

public class MainMenu extends Frame implements ActionListener, WindowListener{

  int		type = -1;
  Vector	windows = new Vector(1, 1);
  String	paramsFileName = ".flaprc";
  boolean	isApplet = false;
  Environment   target;

  static String STR_FSA = "Finite State Automaton";
  static String STR_PDA = "Pushdown Automaton";
  static String STR_1TM = "1-tape Turing Machine";
  static String STR_2TM = "2-tape Turing Machine";
  static String STR_QUIT = "QUIT";
  public final static String osName = System.getProperty("os.name");
  public final static String fileSeparator = System.getProperty("file.separator");
  public static String workingDirectory = System.getProperty("user.dir");
  
  public static final String OK_STR = "Ok";
  public static final String CANCEL_STR = "Cancel";
  public static final String[] OK_CANCEL_STR = {OK_STR, CANCEL_STR};
  public static final String LABEL_WARNING_STR = 
    "Labels can have only one letter when \n converting to a DFA. \n Click \"Ok\" to split them into multiple states.";

   static {
    if (workingDirectory == null)
      workingDirectory = "";
    else if (!workingDirectory.endsWith(fileSeparator))
      workingDirectory += fileSeparator;
  }
 
  public MainMenu() {}
 
  public MainMenu(String args[], boolean isApplet) {
    super("JFlap - Main Menu");
    this.isApplet = isApplet;
    this.addWindowListener(this);
    setLayout(new GridLayout(5, 1));
    Button c;
    Color color = Params._mm_backcolor;
    add(c = new Button(STR_FSA));
    c.setBackground(color);
    c.addActionListener(this);
    add(c = new Button(STR_PDA));
    c.setBackground(color);
    c.addActionListener(this);
    add(c = new Button(STR_1TM));
    c.setBackground(color);
    c.addActionListener(this);
    add(c = new Button(STR_2TM));
    c.setBackground(color);
    c.addActionListener(this);
    add(c = new Button(STR_QUIT));
    c.setBackground(color);
    c.addActionListener(this);
    if (args != null)
      parseArgs(args);
  }

  public void windowClosing(WindowEvent e) 
  {
    quit(null);
  }
  public void windowOpened(WindowEvent e) 
  {}
  public void windowIconified(WindowEvent e) 
  {}
  public void windowDeiconified(WindowEvent e) 
  {}
  public void windowClosed(WindowEvent e)
  {}
  public void windowActivated(WindowEvent e) 
  {}
  public void windowDeactivated(WindowEvent e) 
  {}

  public void actionPerformed(ActionEvent e){
    Environment f;
    DialogThread actionThread;
     
    if (e.getSource() instanceof Button)
      {
	String arg = ((Button)(e.getSource())).getLabel();

	if (STR_QUIT.equals(arg)) {
	  target = null;
	  actionThread = new DialogThread(this, 5);
	  actionThread.start();       
	}  else {
      if (STR_FSA.equals(arg))
	type = Machine.FSA;
      else if (STR_PDA.equals(arg))
	type = Machine.PDA;
      else if (STR_1TM.equals(arg))
	type = Machine.TM1;
      else if (STR_2TM.equals(arg))
	type = Machine.TM2;
      
      else
	return;
      f = createEnvironment(type, Environment.NO_FILE_NAME);
      f.setVisible(true);
	}
      }
    else if (e.getSource() instanceof Environment) {
      String arg = e.getActionCommand();
      if (Environment.CLOSE_STR.equals(arg)) {
	f = (Environment) e.getSource();
	    /*try { 
	      Thread.currentThread().sleep(200);
	      } catch (InterruptedException ex) {}*/
        windows.removeElement(f);
        f.setVisible(false);
        if(f.getEnvSource() != null)
	  f.getEnvSource().setEnvTarget(null);
	if(f.oldTree != null) {
	  f.oldTree.setVisible(false);
	  windows.removeElement(f.oldTree);
	}
	  
      }
      else if (Environment.TO_DFA_STR.equals(arg)) {
	Environment env = (Environment) e.getSource();
	f = createEnvironment(Machine.FSA, Environment.NO_FILE_NAME);
	f.setToDfa(env);
	f.setVisible(true);
	f.pack();
      }
      else if (Environment.MINIMIZE_STR.equals(arg)) {
	Environment env = (Environment) e.getSource();
	f = createEnvironment(Machine.MTC, Environment.NO_FILE_NAME);
	f.setToMinimizeTree(env);
	f.setVisible(true);
	f.pack();
      }
      else if (Environment.DONE_MINIMIZE_STR.equals(arg)) {
	Environment env = (Environment) e.getSource();
	f = createEnvironment(Machine.FSA, Environment.NO_FILE_NAME);
	f.setToMinimizeFinal(env);
	f.setVisible(true);
	f.pack();
      }

    }
    else if (e.getSource() instanceof MenuItem) {
      String arg = ((MenuItem)(e.getSource())).getLabel();
      
      if (Environment.QUIT_STR.equals(arg)) {
	target = null;
	actionThread = new DialogThread(this, 5);
	actionThread.start();       
      }
    }
  }
  
  public Dimension getPreferredSize() {
    return new Dimension(Params._mm_width, Params._mm_height);
  }

  /**
   * Checks if the user wants to save all the unsaved machines and
   * exits if the user didn't cancel the operation.
   */
  public boolean quit(Object first) {
    Environment f;

    if (first != null) {
      f = (Environment) first;
      f.show();
      if (!f.testSavedAndProceed())
        return false;
      windows.removeElement(f);
      f.setVisible(false);
      if(f.getEnvSource() != null)
	f.getEnvSource().setEnvTarget(null);
      if(f.oldTree != null) {
	f.oldTree.setVisible(false);
	windows.removeElement(f.oldTree);
      }
    }
    int i = 0;
    while (i < windows.size()) {
      f = (Environment) windows.elementAt(i);
      f.show();
      if (!f.testSavedAndProceed())
        return false;
      windows.removeElement(f);
      f.setVisible(false);
      if(f.getEnvSource() != null)
	f.getEnvSource().setEnvTarget(null);
      if(f.oldTree != null) {
	f.oldTree.setVisible(false);
	windows.removeElement(f.oldTree);
      }
    }
    setVisible(false);
    System.exit(0);
    return true;
  }	// end of method quit.
   
  /**
   * Parses the command line arguments.
   */
  void parseArgs(String args[]) {
    int		i = 0;
    String	arg;
    String	fileName = Environment.NO_FILE_NAME;

    while (i < args.length) {
      if (args[i].startsWith("-")) {
        arg = args[i++];
        if (i == 1) {
          if (arg.equalsIgnoreCase("-p"))
            if (i < args.length)
              if (!args[i].startsWith("-"))
                paramsFileName = args[i++];
          readParams();
        }
        if (i < args.length)
          if (!args[i].startsWith("-"))
            fileName = args[i++];
        if (arg.equalsIgnoreCase("-fa"))
          createEnvironment(Machine.FSA, fileName);
        else if (arg.equalsIgnoreCase("-pda"))
           createEnvironment(Machine.PDA, fileName);
        else if (arg.equalsIgnoreCase("-tm") || arg.equalsIgnoreCase("-tm1"))
          createEnvironment(Machine.TM1, fileName);
        else if (arg.equalsIgnoreCase("-ttm") || arg.equalsIgnoreCase("-tm2"))
          createEnvironment(Machine.TM2, fileName);
      }
      else 
	i++;
    }
  }	// end of method parseArgs.

  /**
   * Reads the parameters from the parameters file.
   */
  protected void readParams() {
    FileInputStream	fis;
    Properties		params = new Properties();

    try {
     fis = new FileInputStream(paramsFileName);
     params.load(fis);
     fis.close();
    } catch (Exception e) {
     System.err.println("jflap: unable to open file "+paramsFileName);
     return;
    }
    Params.load(params);
  }


  /**
   * Creates a new environment and adds it ot the list of windows
   * currently opened.
   */
  protected Environment createEnvironment(int machineType, String aFileName) {
    Environment	f;

    setCursor(new Cursor(Frame.WAIT_CURSOR));
    f = new Environment(machineType, aFileName, this, isApplet);
    f.setSize(Params._e_width, Params._e_height);
    windows.addElement(f);
    f.setLocation(f.getLocation().x + windows.indexOf(f)*20, 
		  f.getLocation().y + windows.indexOf(f)*20);
    f.pack();
    setCursor(new Cursor(Frame.DEFAULT_CURSOR));
    return f;
  }

  /**
   * Shows all the Environment windows.
   */
  public void showWindows() {
    Environment f;

    for (Enumeration e=windows.elements(); e.hasMoreElements(); ) {
      f = (Environment) e.nextElement();
      f.show();
    }
  }

  void threadAction(int id) {
    quit(target);
  }

}  // end of class MainMenu
