/*---------------------------------------------------------------------------
File:         			FsaLabelBreaker.java
Package:                        JFLAP Version 2.0
Author:				Magda & Octavian Procopiuc V1.0 07/15/96
                                Eric Gramond V2.0 07/22/97 
 
Description of Contents:	Contains class FsaLabelBreaker.
				
--------------------------------------------------------------------------*/

/* 
 * Susan H. Rodger, Magda Procopiuc, Octavian Procopiuc, Eric Gramond
 * Computer Science Department
 * Duke University
 * June 1997
 * Supported by National Science Foundation DUE-9596002 and DUE-9555084.
 *
 * Copyright (c) 1997
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the author.  The name of the author may not be used to
 * endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */




package flap;

import java.util.*; 

/**
  * This class takes care of breaking up the labels thatcontain mutiple letters in an FSA
  *
  * @author	Magda & Octavian Procopiuc
  * @version	1.0 15 July 1996
  */ 
public class LabelSeparator {


  Desktop d;
  
  public LabelSeparator(FSA target) {
    d = target.d;
  }

  /** Returns whether any of the transitions have more than 1 letter.
    * Works only on FSA's.    */ 
  public boolean checkMultiLetterLabels() {
    String lab;
    Vector aVector;
    Transition aTransition;
    Enumeration e2;

    for (Enumeration e = d.theTransitions.elements(); e.hasMoreElements(); ) {
      aTransition  = ((Transition) e.nextElement());
      aVector = aTransition.tokenizeOrList();
      for(e2 = aVector.elements(); e2.hasMoreElements(); ) {
	lab = (String) e2.nextElement();
	lab = lab.trim();
	if(lab.length() > 1)  
	  return true;
      }
    }
    return false;
  }

  /** Break up multiple letter labels into several states linked with single letter labels.
    * works only on FSA's.    */
  public void breakupMultipleLabels() {
    String lab;
    Transition transi;
    Vector aVector;
    Enumeration e2;
 
    d.selectedTransition = null;
    for (int i = d.theTransitions.size()-1; i >= 0 ; i-- ) {
      transi = (Transition) d.theTransitions.elementAt(i);
      aVector = transi.tokenizeOrList();
      for (e2 = aVector.elements(); e2.hasMoreElements(); ) {
	lab = (String) e2.nextElement();
	lab = lab.trim();
	if(lab.length() > 1)  
	  breakupLabel(transi); 
      }
      transi.st = Transition.NORMAL;
    }
    d.repaint();
  }

  /** break up a single multiple letter label. Used by breakupMultipleLabels  */
  private void breakupLabel(Transition transi) {
    
    Transition tempTrans;
    int i;
    int increment = 0;
    int xdist = (transi.to.p.x - transi.from.p.x);
    int ydist = (transi.to.p.y - transi.from.p.y);
    int length;
    Vector aVector = transi.tokenizeOrList();
    Vector finalList = new Vector();
    String sublabel;
    State tempState;
    State prevState;
    int X, Y;
    double X1, Y1;

    for(Enumeration e= aVector.elements(); e.hasMoreElements(); ) {
      sublabel = ((String) e.nextElement()).trim();
      if(sublabel.length()<=1) {
	finalList.addElement(sublabel);
	if(increment==0)
	  increment = 50;
	continue;
      }
      length = sublabel.length();
      prevState = transi.from;
      for(i = 0; i< length-1; i++) {
	if(transi.from != transi.to) 
	  tempState = d.addState(transi.from.p.x + ((xdist * (i+1) )/length),
			       increment+ transi.from.p.y + ((ydist * (i+1) )/length));
	else {
	  X1 = ((i+1) * (2*Math.PI/length)) - (Math.PI/2);
	  Y1 = ((i+1) * (2*Math.PI/length)) - (Math.PI/2);	   
	  X = (int) (Math.cos(X1) * 15 * length);
	  Y = (int) ((Math.sin(Y1) * 15 * length ) + (15 * length));
	  tempState = d.addState(transi.from.p.x + X, transi.from.p.y + Y);
	}
	tempTrans = d.addTransition(prevState, tempState);
	tempTrans.label += sublabel.charAt(i);     
	prevState = tempState;
      }
      tempTrans = d.addTransition(prevState, transi.to);
      tempTrans.label += sublabel.charAt(i);
      increment += 50;
    }
    if(finalList.size() != 0)
      transi.setLabel(finalList);
    else
      d.removeTransition(transi);
  }


}
