/*---------------------------------------------------------------------------
File:         			HelpDialog.java
Package:                        JFLAP Version 2.0
Author:				Magda & Octavian Procopiuc V1.0 07/15/96
                                Eric Gramond V2.0 07/22/97 
 
Description of Contents:	Contains class HelpDialog.
				
--------------------------------------------------------------------------*/

/* 
 * Susan H. Rodger, Magda Procopiuc, Octavian Procopiuc, Eric Gramond
 * Computer Science Department
 * Duke University
 * June 1997
 * Supported by National Science Foundation DUE-9596002 and DUE-9555084.
 *
 * Copyright (c) 1997
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the author.  The name of the author may not be used to
 * endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

package flap;

import java.awt.*;
import java.util.*;
import java.awt.event.*;
/**
 * This is the dialog that appears when the user 
 * chooses one of the items in the Help menu.
 * All the text is displayed in a TextArea,
 * which has its own scroll bars.
 *
 * @author	Magda & Octavian Procopiuc
 * @version	1.0 15 July 1996
 */
public class HelpDialog extends Dialog implements ActionListener {

  final static int	OVERVIEW	= 0;
  final static int	STATE		= 5;
  final static int	TRANSITION	= 15;
  final static int	UPPERWINDOW	= 20;
  final static int	TRACEWINDOW	= 25;
  final static int	MENUBAR		= 30;
  final static int      NFATODFA        = 35;
  final static int      MINIMIZE        = 40;

  protected String[]	allText = new String[50];
  protected String	text = "nothing";	
  protected int		helpOnWhat;
  protected TextArea	textArea;

  public HelpDialog(int helpOnWhat, Frame parent) {
    super(parent, "", true);
    setTitle(getTitle(helpOnWhat));
    this.helpOnWhat = helpOnWhat;
    setAllText();
    text = allText[helpOnWhat];
    setBackground(Params._h_backcolor);
    setLayout(new BorderLayout());
    Panel p = new Panel();
    Button b = new Button("     OK     ");
    p.add(b);
    b.addActionListener(this);
    b.setBackground(Params._bt_backcolor);
    add("South", p);
    p = new Panel();
    p.setLayout(new BorderLayout());
    p.add("Center", textArea = new TextArea(Params._h_rows, Params._h_columns));
    // textArea.setBackground(new Color(255, 200, 200));
    textArea.setEditable(false);
    //p.add("East", new Scrollbar(Scrollbar.VERTICAL));
    add("Center", p);
    textArea.setFont(Params._h_font);
    textArea.setText(parseText());
  }
    
  public void actionPerformed(ActionEvent e) {
    if (e.getSource() instanceof Button) {
      setVisible(false);
    }
  }	// end of method action.


  /**
   * This method is supposed to format the text
   * to fit in the window. It's not totally reliable.
   */
  protected String parseText() {
    String	answer = "";
    StringTokenizer	st = new StringTokenizer(text, " \t\n\r", true);
    int		cmax = textArea.getColumns();
    int		c = 0;
    String	buffer = "";

    while (st.hasMoreTokens()) {
      buffer = st.nextToken();

      if (buffer.indexOf("\n") != -1)
        c = 0;
      else
        c += buffer.length();
      if (c >= cmax) {
        c = 0;
        answer += "\n";
      }
      answer += buffer;
    }
    return answer;
  }	// end of method parseText.

 /**
  * Sets the actual text in the allText array.
  */
  protected void setAllText() {
    allText[OVERVIEW] = 	// for the FSA.
	"\tOverview\n\n"+
	"This application is a graphical tool for the creation and simulation of finite state automata\n\n"+
	"The mouse is used to draw the transition graph of the automaton on the canvas. The canvas is the large rectangular region which is initially blank. States are represented as disks, while transitions are labeled arcs connecting two states.\n\n"+
	"The states of an automaton may be moved about on the canvas once they have been created, to make the layout more eye-pleasing. See the Help on States to find out how to do that.\n\n"+
	"NOTE: to open directly a canvas with a Finite State Automaton when starting the program, type:\n\tjava JFLAP -fa [file name with or without the '.FSA' extension]\nIf the file name is missing, or the file as given could not be opened, a blank canvas is opened.\n";  

    allText[OVERVIEW + 1] = 	// for the PDA.
	"\tOverview\n\n"+
	"This application is a graphical tool for the creation and simulation of pushdown automata\n\n"+
	"The mouse is used to draw the transition graph of the automaton on the canvas. The canvas is the large rectangular region which is initially blank. States are represented as disks, while transitions are labeled arcs connecting two states.\n\n"+
	"The states of an automaton may be moved about on the canvas once they have been created, to make the layout more eye-pleasing. See the Help on States to find out how to do that.\n\n"+
	"NOTE: to open directly a canvas with a Pushdown Automaton when starting the program, type:\n\tjava JFLAP -pda [file name with or without the '.PDA' extension]\nIf the file name is missing, or the file as given could not be opened, a blank canvas is opened.\n"; 

    allText[OVERVIEW + 2] = 	// for the TM1
	"\tOverview\n\n"+
	"This application is a graphical tool for the creation and simulation of one-tape Turing Machines\n\n"+
	"The mouse is used to draw the transition graph of the machine on the canvas. The canvas is the large rectangular region which is initially blank. States are represented as disks, while transitions are labeled arcs connecting two states.\n\n"+
	"The states of an automaton may be moved about on the canvas once they have been created, to make the layout more eye-pleasing. See the Help on States to find out how to do that.\n\n"+
	"NOTE: to open directly a canvas with a one-tape Turing Machine when starting the program, type:\n\tjava JFLAP -tm [file name with or without the '.TM' extension]\nIf the file name is missing, or the file as given could not be opened, a blank canvas is opened.\n";

    allText[OVERVIEW + 3] = 	// for the TM2
	"\tOverview\n\n"+
	"This application is a graphical tool for the creation and simulation of two-tape Turing Machines\n\n"+
	"The mouse is used to draw the transition graph of the machine on the canvas. The canvas is the large rectangular region which is initially blank. States are represented as disks, while transitions are labeled arcs connecting two states.\n\n"+
	"The states of an automaton may be moved about on the canvas once they have been created, to make the layout more eye-pleasing. See the Help on States to find out how to do that.\n\n"+
	"NOTE: to open directly a canvas with a two-tape Turing Machine when starting the program, type:\n\tjava JFLAP -ttm [file name with or without the '.TTM' extension]\nIf the file name is missing, or the file as given could not be opened, a blank canvas is opened.\n";

    allText[STATE] = allText[STATE+1] = allText[STATE+2] = allText[STATE+3] =
	"\tHelp on: State\n\n"+
	"Rule of thumb: The states are handled with the CENTER MOUSE BUTTON (if you use a three-button mouse) or with SHIFT & LEFT BUTTON\n\n"+
	"To create a state click the center button on a clear area of the canvas.\n\n"+
	"To move a state, drag it holding the center button down.\n\n"+
	"To delete a state, remove a state or make a state initial or final, "+
	"place the cursor within the state, and hold the RIGHT button "+
	"(or CTRL & LEFT button) down while selecting the desired operation "+
	"from the popup menu, then release the button.\n\n";

    allText[TRANSITION] = 
	"\tHelp on: Transition\n\n"+
	"Rule of thumb: The transitions are handled with the LEFT MOUSE BUTTON\n\n"+
	"To create a transition press and hold the left button within the origin state, and release it within the destination state\n\n"+
	"To delete a transition place the cursor within transition label, press and hold the RIGHT mouse button (or CTRL & LEFT button) while selecting the desired item in the popup menu, then release the button.\n\n"+
	"To edit a transition label, press the left button within the"+
	" label to select it. Then edit its contents using the keyboard."+
	" A lambda transition is created by simply leaving the contents"+
	" blank. More than a transition can be written in one label by"+
	" separating them with commas.\n\n"+
	"NOTE: In the current release you are not able to move the label of a transition unless the transition has the same origin state and destination state. In this case, you can drag the label up and down using the left mouse button.\n\n";

    allText[TRANSITION+1] = //for the PDA;
	"\tHelp on: Transition\n\n"+
	"Rule of thumb: The transitions are handled with the LEFT MOUSE BUTTON\n\n"+
	"To create a transition press and hold the left button within the origin state, and release it within the destination state\n\n"+
	"To delete a transition place the cursor within transition label, press and hold the RIGHT mouse button (or CTRL & LEFT button) while selecting the desired item in the popup menu, then release the button.\n\n"+
	"To edit a transition label, press the left button within the label to select it. Then edit its contents using the keyboard. To move to a different field of the label, use the arrow keys or TAB and SHIFT-TAB.\n\n"+
	"A label has 3 fields:\n\n"+
	"\t<input to read> , <string to pop from stack> ; <string to push on stack>\n\n"+
	"NOTE: In the current release you are not able to move the label of a transition unless the transition has the same origin state and destination state. In this case, you can drag the label up and down using the left mouse button.\n\n";

    allText[TRANSITION+2] = //for the TM1;
	"\tHelp on: Transition\n\n"+
	"Rule of thumb: The transitions are handled with the LEFT MOUSE BUTTON\n\n"+
	"To create a transition press and hold the left button within the origin state, and release it within the destination state\n\n"+
	"To delete a transition place the cursor within transition label, press and hold the RIGHT mouse button (or CTRL & LEFT button) while selecting the desired item in the popup menu, then release the button.\n\n"+
	"To edit a transition label, press the left button within the label to select it. Then edit its contents using the keyboard. To move to a different field of the label, use the arrow keys or TAB and SHIFT-TAB.\n\n"+
	"A label has 3 fields:\n\n"+
	"\t<symbol to read> , <symbol to write> ; <direction (R, L or S)>\n\n"+
	"The B character (capital b) denotes the blank symbol.\n\n"+
	"NOTE: In the current release you are not able to move the label of a transition unless the transition has the same origin state and destination state. In this case, you can drag the label up and down using the left mouse button.\n\n";

    allText[TRANSITION+3] = // for the TM2;
	"\tHelp on: Transition\n\n"+
	"Rule of thumb: The transitions are handled with the LEFT MOUSE BUTTON\n\n"+
	"To create a transition press and hold the left button within the origin state, and release it within the destination state\n\n"+
	"To delete a transition place the cursor within transition label, press and hold the RIGHT mouse button (or CTRL & LEFT button) while selecting the desired item in the popup menu, then release the button.\n\n"+
	"To edit a transition label, press the left button within the label to select it. Then edit its contents using the keyboard. To move to a different field of the label, use the arrow keys or TAB and SHIFT-TAB.\n\n"+
	"A label has 6 fields:\n\n"+
	"\t<symbol to read from tape 1> , <symbol to write on tape 1> ; <direction (R, L or S) on tape 1> | <symbol to read from tape 2> , <symbol to write on tape 2> ; <direction (R, L or S) on tape 2>\n\n"+
	"The B character (capital b) denotes the blank symbol.\n\n"+
	"NOTE: In the current release you are not able to move the label of a transition unless the transition has the same origin state and destination state. In this case, you can drag the label up and down using the left mouse button.\n\n";

    allText[UPPERWINDOW] = allText[UPPERWINDOW+1] = allText[UPPERWINDOW+2] = allText[UPPERWINDOW+3] = 
	"\tHelp on: Step Run Window\n\n"+
	"The Step Run Window displays a number of configurations at a time. Each configuration consists of the current state and the remaining input (and the stack in the case of PDA) for Automata or the current state and the relevant part of the tape (or tapes in the case of TTM) for Turing Machines)\n\n"+
	"Configurations can be selected or unselected by clicking on them. Selected configurations are shown darker. Invalid configurations (i.e. which cannot be expanded any more) are marked with a red cross in the upper left corner.\n\n"+
	"The Run Window Buttons:\n"+
	"\tKill\tDelete all selected configurations.\n"+
	"\tFreeze\tFreeze all selected configurations.\n\t\t(the frozen configurations will not be expanded)\n\t\t(a frozen configuration is marked with a snow flake in the upper left corner)\n"+
	"\tThaw\tUn-freeze all selected configurations.\n"+
	"\tTrace\tView the path of the selected configuration.\n\t\t(exactly one configuration must be selected)\n"+
	"\tStep\tExpand the current set of configurations by applying the next transitions.\n"+
	"\tRestart\tRestart the step run from the start state.\n"+
	"\tQuit\tQuit the Step Run Window and return to the building canvas.\n";

    allText[TRACEWINDOW] =  allText[TRACEWINDOW+1] =  allText[TRACEWINDOW+2] =  allText[TRACEWINDOW+3] = 
	"Help on: Trace Window\n\n"+
	"The Trace Window displays, for a certain configuration, "+
	"the path from the initial configuration to that configuration. "+
	"The Trace Window is shown in one of the following 2 circumstances:\n"+
	"\t1. When the Trace button from the Step Run window is pressed and "+
 	"exactly one configuration is selected.\n"+
	"\t2. When a Fast Run has lead to acceptance and the user chooses to "+
	"see the acceptance path.";

    allText[MENUBAR] = allText[MENUBAR+1] = allText[MENUBAR+2] = allText[MENUBAR+3] = 
	"\tHelp on: The Menu Bar\n\n"+
	"\tFile menu:\n"+
	"\t\tNew:\topens a new machine in the current window.\n"+
	"\t\tOpen:\topens a machine from a file in the current window.\n"+
	"\t\tSave:\tsaves the current machine.\n"+
	"\t\tSave as:\tsaves the current machine in a specified file.\n"+
	"\t\tPrint:\tprints the current machine to the printer or to a file "+
	"\n\t\t\t(to date, only on Unix- and Windows- based machines;"+
	"\n\t\t\tyou can print to a file though, in tabular form, on all machines.)\n"+
	"\t\tClose:\tcloses the current window.\n"+
	"\t\tQuit flap:\texits the program.\n\n"+
	"\tRun menu:\n"+
	"\t\tStep run:\topens the Step Run window.\n"+
	"\t\tFast run:\truns the current machine with the specified input; "+
	"\n\t\t\tif the input is accepted, the user has the possibility to"+
        "\n\t\t\tsee the acceptance path.\n\n"+
	"\tOptions menu:\n"+
	"\t\tRe-label states:\t\trelabels the states so that\n\t\t\t\t\tthe labels are "+
	"consecutive numbers.\n"+
	"\t\tShow nondeterministic states:\tshows the nondeterministic\n\t\t\t\t\tstates "+
	"of the machine, if there are any.\n"+
        "\t\tShow Grammar:\t\tBrings up a window containing a regular\n\t\t\t\t\tgrammar "+
        "corresponding to the FSA\n"+
        "\t\tNFA to DFA: \t\t converts the current NFA to a DFA\n"+
        "\t\t\t\t\t(See help on NFA to DFA). \n"+
        "\t\tShow unreachable states: \tshows the unreachable states\n" +
        "\t\t\t\t\t of the machine, if there are any. \n"+
        "\t\tMinimize: \t\t\t minimizes the current DFA \n" +
        "\t\t\t\t\t (See help on minimize). \n" +
        "\t\tShow Name Labels: \t when is set, the state labels appear.\n"+
        "\t\t\t\t\t (Works on NFA to DFA/Minimize modes)\n"+
	"\t\tAuto Re-label:\t\twhen is set, the states always have\n\t\t\t\t\tconsecutive labels\n";

      allText[NFATODFA] = allText[NFATODFA+1] = allText[NFATODFA+2] = allText[NFATODFA+3] = 
	"\tHelp on: The NFA to DFA options\n\n"+
	"The NFA to DFA option lets you take any Nondeterministic Finite Automaton (NFA) and convert it into an equivalent Deterministic Finite Automaton (DFA).\n" +
	"The NFA to DFA buttons are located in the Options menu. Once an NFA is built, select the \"Convert to DFA\" option in the menubar. A new window will appear in which you can start building the DFA. Note that you can not edit the original NFA window until this window has been closed.\n\n" +
        "Labels: \n  Each state has a name label (rectangular box on top of the state). The name is simply the list of the numbers of the corresponding states separated by commas.\nFor example a state corresponding to the states q0, q2 and q3 should be labeled \"0,2,3\". \nTo enter the name of a state, first select the state by clicking on the label. You can switch between the different fields in the label by using tab and shift-tab just like in a normal transition label. Labels can also be hidden if they take too much space, by toggling the \"Show Name Labels\" in the \"NFA to DFA\" section of the Options menubar.\n\n" +
	"Check if done: \n The \"Check if done\" option in the menubar tells you if your DFA is correct or will show you one of your errors if it is incorrect. Note that it will be alot more precise about errors if you don't disable name labels.\n\n" +
	"Show: \n The \"Show\" option in the menubar will automaticly build the DFA and put it in the window. If you had started to build, it will complete it for you without removing the correct parts.\n\n"+
	"Expand a state: \n The \"Expand a state\" option in the menubar shows the transitions out of the selected state. A state must be selected first by clicking on its name label, which cannot be empty. All transitions from that state will be created, and if they lead to states that are not on the automaton these states will be added. The selected state will also be set to be final or initial if it should be."; 
      allText[MINIMIZE] = allText[MINIMIZE+1] = allText[MINIMIZE+2] = allText[MINIMIZE+3] = 
	"\tHelp on: The DFA Minimizing option\n\n"+
	"The Minimize option gives guidance in building an equivalent DFA with the minimum number of states. \n" +
	"The minimize buttons are located in the Options menu. Once a DFA is built, select the \"Minimize\" option in the menubar. A new window will appear in which you can start building the tree to find undistinguishable states. When done with that window a second window will appear in which you can build the minimized DFA.\n\n" +
	"Note the DFA's are supposed to have a transition leaving from every state for each letter of the machine's alphabet. If any transitions are omited, then you will have an implicit trap state in your automaton. This implicit state will be added as your last state (but not shown in the Finite Automata window) and will be treated in the tree as if it were in your machine (a reminder will pop up when starting the tree if you have an implicit trap state). This trap state will be removed in the second minimizing window since it is only necessary for distingishing states in the tree.\n\n\n"+
        "\tThe Tree Window\n\n" +
	"The tree window will begin with the two trees (final and nonfinal) already started. The final tree's root will contain a label representing all the final states and the nonfinal tree's root will contain a label representing all nonfinal states. For more help on how State labels work see the \"NFA to DFA\" help.\n" +
	"When you are done building the tree click on the \"Done\" button. The next window will appear if the tree is correct.\n" +
	"In the tree window, all the commands are effected using the popup menu (right mouse button)\n\n"+
	"\tDistinguishing States\n\n" +
	"States listed in a node are thus far indistinguishable. To distinguish states in a node N (if this is possible), expand N by creating two or more children and selecting a symbol from the alphabet, say A. For every state in N, calculate the state reachable from N with arc A. If all the reachable states are currently in the same leaf node, then the states in N are thus far still indistinguishable. If the reachable states currently appear in different leaf nodes, then the states in N are distinguishable and grouped into sets based on the groups of their reachable states.\n\n" +
	"Split this node: \nThis command will expand the node by creating two children, and will change the node's color to green to indicate that this node has become the current node to expand. No other nodes can be expanded until this node is properly expanded. A small label will appear under the node. It should be filled in with the letter of the machine's alphabet that is to be used to distinguish the states in this node. The groups of distinguishable states are added in the labels of this node's children, one group per child.\n\n"+
	"Add a child: \nThis command will add a child to the node being expanded if it needs one (i.e. if all other children are already full and there are still states to place.\n\n"+
	"Remove this node: \tThis command will remove the node if its parent is the node being expanded and it has two or more siblings. No node can have only one child.\n\n"+
	"Check this node: \nWill check if the node being expanded is correct. If it isn't it will give you an error indicating what is wrong.\n\n"+
	"Solve this node: \nThis command will fill in the children of the node being expanded with the correct answers. If a proper letter has been picked to distinguish with it will use that one, otherwise it will pick a correct one.\n\n\n"+
	"\tDrawing the Minimum State DFA\n\n" +
	"The second minimizing window appears with all the states generated by the tree already placed. The only thing that needs to be filled in are the transitions, using the original DFA as a model. You can use the Check done, Solve, and Show options from the menubar to check or finish the machine. They work exactly like the ones in the NFA to DFA window. See the help on NFA to DFA for detailed descriptions of these options.\n";	
  }	// end of method setAllText().

  protected String getTitle(int helpOnWhat) {
    switch (helpOnWhat % 5) {
      case 0: return "FSA: Help";
      case 1: return "PDA: Help";
      case 2: return "TM1: Help";
      case 3: return "TM2: Help";
    }
    return "Not an implemented type!";
  }

}	// end of class HelpDialog
