/*---------------------------------------------------------------------------
File:         			FSAToGrammar.java
Package:                        JFLAP Version 1.0
Author:				Magda & Octavian Procopiuc V1.0 07/15/96
                                
Description of Contents:	Contains class FSAToGrammar.
				
--------------------------------------------------------------------------*/

/* 
 * Susan H. Rodger, Magda Procopiuc, Octavian Procopiuc, Eric Gramond
 * Computer Science Department
 * Duke University
 * June 1997
 * Supported by National Science Foundation DUE-9596002 and DUE-9555084.
 *
 * Copyright (c) 1997
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the author.  The name of the author may not be used to
 * endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

package flap;


import	java.util.*;
import  java.awt.*;
import  java.awt.event.*;

/**
  * This is the class that handles converting an FSA to a grammar. The grammar will
  * be regular if there are no lambda transitions.
  */ 
public abstract class FSAToGrammar {


  public static Vector toGramm(Desktop d) {
    State aState;
    Vector answer = new Vector();
    Vector subAnswer;
    Enumeration e2;

    for(Enumeration e = d.theStates.elements(); e.hasMoreElements(); ) 
      d.setTransitions((State) e.nextElement(), true);
    
    for(Enumeration e = d.theStates.elements(); e.hasMoreElements(); ) {
      aState = (State) e.nextElement();
      subAnswer = processState(aState, d);
      for(e2 = subAnswer.elements();  e2.hasMoreElements(); ) 
	answer.addElement( giveName(aState, d) + (String) e2.nextElement());
    }

    sort(answer);
    return answer;

  }

  /** helps the toGramm function */
  private static Vector processState(State s , Desktop d) {
    Transition aTransition;
    String rule;
    Vector answer = new Vector();
    
    for(Enumeration e = s.transitions.elements(); e.hasMoreElements(); ) {
      aTransition = (Transition) e.nextElement();
            
      rule = " -> " + aTransition.label.trim() + " " + giveName(aTransition.to, d);
      if(aTransition.label.trim().length() == 0)
	rule = " -> " + giveName(aTransition.to, d);	
      
      answer.addElement(rule);
    }
    if(s.isFinal)
      answer.addElement(" -> lambda");

    return answer;
  }


  /** 
    * finds a name to a state for the grammar
    */
  public static String giveName(State s, Desktop d) {
    if(d.initialState == s)
      return "S";
    return "q"+s.id;
  }



  /** 
    * Sorts all the rules in lexicographical order (whow, Stever is right, once you 
    * use the word 'lexicographical' once you just can't go back to 'alphabetical'
    * anymore) and then puts all the ones starting with S on top.
    */

  public static void sort(Vector answer)     {    
    String aString;
    VectorArray arr = new VectorArray(answer);

    Sorting.sort(arr, new StringSorter());

    while(answer.size() > 0)
      answer.removeElementAt(0);

    for(Enumeration e = arr.elements(); e.hasMoreElements(); ) {
      aString = (String) e.nextElement();
      if(aString.trim().charAt(0) == 'S') 
	answer.addElement(aString);
    }
    
    for(Enumeration e = arr.elements(); e.hasMoreElements(); ) {
      aString = (String) e.nextElement();
      if(aString.trim().charAt(0) != 'S') 
	answer.addElement(aString);
    }
  }

  public static void displayGrammar(Desktop d) {
    Vector answer = toGramm(d);
    String grammar = new String();
    final Frame aFrame = new Frame("Grammar Window");
    
    for(Enumeration e = answer.elements(); e.hasMoreElements(); ) {
      grammar += (String) e.nextElement();
      if(e.hasMoreElements())
	grammar += "\n";
    }  

    aFrame.removeAll();
    aFrame.setLayout(new BorderLayout());
    aFrame.setBackground(Params._e_backcolor);

    Button done =  new Button("Done");
    done.addActionListener(new ActionListener()	{
			     public void actionPerformed(ActionEvent ae) {
				 aFrame.setVisible(false);
			       }
			   });
    
    TextArea area= new TextArea(grammar, Math.min(10, answer.size()+2), 20, TextArea.SCROLLBARS_VERTICAL_ONLY);
    area.setEditable(false);
    area.setBackground(Color.white);
    
    aFrame.add("North", area);
    Panel p = new Panel();    
    p.add(done);
    aFrame.add("South", p);
    aFrame.pack();
    aFrame.setVisible(true);

    
  }
  


}
