/*---------------------------------------------------------------------------
File:         			DialogThread.java
Package:                        JFLAP Version 1.0
Author:				Magda & Octavian Procopiuc V1.0 07/15/96
                                
Description of Contents:	Contains class DialogThread.
				
--------------------------------------------------------------------------*/

/* 
 * Susan H. Rodger, Magda Procopiuc, Octavian Procopiuc, Eric Gramond
 * Computer Science Department
 * Duke University
 * June 1997
 * Supported by National Science Foundation DUE-9596002 and DUE-9555084.
 *
 * Copyright (c) 1997
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the author.  The name of the author may not be used to
 * endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

package flap;

import java.awt.*;

/**
 * This is a thread used to work around the fact that method show()
 * in class Dialog in JDK 1.0.2 is not blocking (on Win95).
 * Should be removed when this bug is solved.
 *
 * @author Magda & Octavian Procopiuc
 * @version 1.0 15 July 1996
 */
public class DialogThread extends Thread {
  Frame env;  // the Frame where threadAction() is defined
  int id;     // thread id; used to determine what type
              // dialog this thread is created for
  ThreadDialog dg;  // the dialog for which the thread is created

/**
 * Creates a thread with the given id.
 * This thread's run() will call threadAction(id) which is 
 * defined in env.
 */ 
  public DialogThread(Frame env, int id) {
    this(env, id, null);
  }
  
/**
 * Creates a thread with the given id.
 * This thread's run() will call threadAction(dg) which is
 * defined in env.
 */ 
  public DialogThread(Frame env, int id, ThreadDialog dg) {
    this.env = env;
    this.id = id;
    this.dg = dg; 
  }

  public void run() {
    if (env instanceof Environment)
      ((Environment) env).threadAction(id);
    else if (env instanceof MainMenu)
      ((MainMenu) env).threadAction(id);  
    else if (env instanceof UpperWindow)
      ((UpperWindow) env).threadAction(dg);
  }

}
