/*---------------------------------------------------------------------------
File:         			AppletMenu.java
Package:                        JFLAP Version 2.0
Author:				Magda & Octavian Procopiuc V1.0 07/15/96
                                Eric Gramond V2.0 07/22/97 
 
Description of Contents:	Contains class AppletMenu.
				
--------------------------------------------------------------------------*/

/* 
 * Susan H. Rodger, Magda Procopiuc, Octavian Procopiuc, Eric Gramond
 * Computer Science Department
 * Duke University
 * June 1997
 * Supported by National Science Foundation DUE-9596002 and DUE-9555084.
 *
 * Copyright (c) 1997
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the author.  The name of the author may not be used to
 * endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

package flap;

import java.awt.*;
import java.util.*;
import java.io.*;
import java.awt.event.*;
import java.applet.*;

/**
 * The initial menu which enables the user to open
 * as many Environment windows as he/she wants
 * with the desired machine type. Basically,
 * it contains one button for each machine type
 * and an exit button.
 *
 * @see		flap.Environment
 * @author	Magda & Octavian Procopiuc
 * @version	2.0 15 July 1997
 */

public class AppletMenu extends MainMenu {


  Applet        parent;

  public AppletMenu(String attr, Applet app) {

    if (attr != null)
      Params._e_exampleurl = attr;
    isApplet = true;
    parent = app;
    parent.setLayout(new GridLayout(2, 2));
    Button c;
    Color color = new Color(138, 138, 255);
    parent.add(c = new Button(STR_FSA));
    c.setBackground(color);
    c.addActionListener(this);
    parent.add(c = new Button(STR_PDA));
    c.setBackground(color);
    c.addActionListener(this);
    parent.add(c = new Button(STR_1TM));
    c.setBackground(color);
    c.addActionListener(this);
    parent.add(c = new Button(STR_2TM));
    c.setBackground(color);
    c.addActionListener(this);
  }

  /*  public void actionPerformed(ActionEvent e) {
    Environment f;

    if (e.getSource() instanceof Button) {
      String arg = ((Button)(e.getSource())).getLabel();      
      if (STR_FSA.equals(arg))
	type = Machine.FSA;
      else if (STR_PDA.equals(arg))
	type = Machine.PDA;
      else if (STR_1TM.equals(arg))
	type = Machine.TM1;
      else if (STR_2TM.equals(arg))
	type = Machine.TM2;
      else {
	return;
      }
      parent.showStatus("Loading...");
      f = new Environment(type, Environment.NO_FILE_NAME, this, true);
      f.setSize(Params._e_width, Params._e_height);
      f.pack();
      f.show();
      windows.addElement(f);
      parent.showStatus("Loading finished.");
    } else if (e.getSource() instanceof Environment) {
      String arg = e.getActionCommand();
      if (Environment.CLOSE_STR.equals(arg)) {
        f = (Environment) e.getSource();
        windows.removeElement(f);
        f.setVisible(false);
      }
    }
    return;
  }*/
  
}
